package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.IdType
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetEnvironmentRequest(environmentId: IdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.GetEnvironmentRequest = {
    import GetEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.GetEnvironmentRequest
      .builder()
      .environmentId(IdType.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.GetEnvironmentRequest.ReadOnly =
    zio.aws.finspace.model.GetEnvironmentRequest.wrap(buildAwsValue())
}
object GetEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.GetEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.GetEnvironmentRequest =
      zio.aws.finspace.model.GetEnvironmentRequest(environmentId)
    def environmentId: IdType
    def getEnvironmentId: ZIO[Any, Nothing, IdType] = ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.GetEnvironmentRequest
  ) extends zio.aws.finspace.model.GetEnvironmentRequest.ReadOnly {
    override val environmentId: IdType =
      zio.aws.finspace.model.primitives.IdType(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.GetEnvironmentRequest
  ): zio.aws.finspace.model.GetEnvironmentRequest.ReadOnly = new Wrapper(impl)
}
