package zio.aws.finspace.model
import scala.jdk.CollectionConverters._
sealed trait RuleAction {
  def unwrap: software.amazon.awssdk.services.finspace.model.RuleAction
}
object RuleAction {
  def wrap(
      value: software.amazon.awssdk.services.finspace.model.RuleAction
  ): zio.aws.finspace.model.RuleAction = value match {
    case software.amazon.awssdk.services.finspace.model.RuleAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspace.model.RuleAction.ALLOW =>
      val r = allow
      r
    case software.amazon.awssdk.services.finspace.model.RuleAction.DENY =>
      val r = deny
      r
  }
  case object unknownToSdkVersion extends zio.aws.finspace.model.RuleAction {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.RuleAction =
      software.amazon.awssdk.services.finspace.model.RuleAction.UNKNOWN_TO_SDK_VERSION
  }
  case object allow extends zio.aws.finspace.model.RuleAction {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.RuleAction =
      software.amazon.awssdk.services.finspace.model.RuleAction.ALLOW
  }
  case object deny extends zio.aws.finspace.model.RuleAction {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.RuleAction =
      software.amazon.awssdk.services.finspace.model.RuleAction.DENY
  }
}
