package zio.aws.finspace.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{
  ResultLimit,
  PaginationToken,
  KxClusterName,
  KxEnvironmentId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListKxClusterNodesRequest(
    environmentId: KxEnvironmentId,
    clusterName: KxClusterName,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[ResultLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.ListKxClusterNodesRequest = {
    import ListKxClusterNodesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.ListKxClusterNodesRequest
      .builder()
      .environmentId(KxEnvironmentId.unwrap(environmentId): java.lang.String)
      .clusterName(KxClusterName.unwrap(clusterName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ResultLimit.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.ListKxClusterNodesRequest.ReadOnly =
    zio.aws.finspace.model.ListKxClusterNodesRequest.wrap(buildAwsValue())
}
object ListKxClusterNodesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.ListKxClusterNodesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.ListKxClusterNodesRequest =
      zio.aws.finspace.model.ListKxClusterNodesRequest(
        environmentId,
        clusterName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def environmentId: KxEnvironmentId
    def clusterName: KxClusterName
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[ResultLimit]
    def getEnvironmentId: ZIO[Any, Nothing, KxEnvironmentId] =
      ZIO.succeed(environmentId)
    def getClusterName: ZIO[Any, Nothing, KxClusterName] =
      ZIO.succeed(clusterName)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.ListKxClusterNodesRequest
  ) extends zio.aws.finspace.model.ListKxClusterNodesRequest.ReadOnly {
    override val environmentId: KxEnvironmentId =
      zio.aws.finspace.model.primitives.KxEnvironmentId(impl.environmentId())
    override val clusterName: KxClusterName =
      zio.aws.finspace.model.primitives.KxClusterName(impl.clusterName())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.finspace.model.primitives.PaginationToken(value))
    override val maxResults: Optional[ResultLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.finspace.model.primitives.ResultLimit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.ListKxClusterNodesRequest
  ): zio.aws.finspace.model.ListKxClusterNodesRequest.ReadOnly = new Wrapper(
    impl
  )
}
