package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{IdType, KxUserNameString}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetKxUserRequest(
    userName: KxUserNameString,
    environmentId: IdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.GetKxUserRequest = {
    import GetKxUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.GetKxUserRequest
      .builder()
      .userName(KxUserNameString.unwrap(userName): java.lang.String)
      .environmentId(IdType.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.GetKxUserRequest.ReadOnly =
    zio.aws.finspace.model.GetKxUserRequest.wrap(buildAwsValue())
}
object GetKxUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.GetKxUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.GetKxUserRequest =
      zio.aws.finspace.model.GetKxUserRequest(userName, environmentId)
    def userName: KxUserNameString
    def environmentId: IdType
    def getUserName: ZIO[Any, Nothing, KxUserNameString] = ZIO.succeed(userName)
    def getEnvironmentId: ZIO[Any, Nothing, IdType] = ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.GetKxUserRequest
  ) extends zio.aws.finspace.model.GetKxUserRequest.ReadOnly {
    override val userName: KxUserNameString =
      zio.aws.finspace.model.primitives.KxUserNameString(impl.userName())
    override val environmentId: IdType =
      zio.aws.finspace.model.primitives.IdType(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.GetKxUserRequest
  ): zio.aws.finspace.model.GetKxUserRequest.ReadOnly = new Wrapper(impl)
}
