package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  KxUserNameString,
  RoleArn,
  IdType,
  TagValue,
  ClientToken,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateKxUserRequest(
    environmentId: IdType,
    userName: KxUserNameString,
    iamRole: RoleArn,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.CreateKxUserRequest = {
    import CreateKxUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.CreateKxUserRequest
      .builder()
      .environmentId(IdType.unwrap(environmentId): java.lang.String)
      .userName(KxUserNameString.unwrap(userName): java.lang.String)
      .iamRole(RoleArn.unwrap(iamRole): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.CreateKxUserRequest.ReadOnly =
    zio.aws.finspace.model.CreateKxUserRequest.wrap(buildAwsValue())
}
object CreateKxUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.CreateKxUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.CreateKxUserRequest =
      zio.aws.finspace.model.CreateKxUserRequest(
        environmentId,
        userName,
        iamRole,
        tags.map(value => value),
        clientToken.map(value => value)
      )
    def environmentId: IdType
    def userName: KxUserNameString
    def iamRole: RoleArn
    def tags: Optional[Map[TagKey, TagValue]]
    def clientToken: Optional[ClientToken]
    def getEnvironmentId: ZIO[Any, Nothing, IdType] = ZIO.succeed(environmentId)
    def getUserName: ZIO[Any, Nothing, KxUserNameString] = ZIO.succeed(userName)
    def getIamRole: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(iamRole)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.CreateKxUserRequest
  ) extends zio.aws.finspace.model.CreateKxUserRequest.ReadOnly {
    override val environmentId: IdType =
      zio.aws.finspace.model.primitives.IdType(impl.environmentId())
    override val userName: KxUserNameString =
      zio.aws.finspace.model.primitives.KxUserNameString(impl.userName())
    override val iamRole: RoleArn =
      zio.aws.finspace.model.primitives.RoleArn(impl.iamRole())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.finspace.model.primitives
              .TagKey(key) -> zio.aws.finspace.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.finspace.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.CreateKxUserRequest
  ): zio.aws.finspace.model.CreateKxUserRequest.ReadOnly = new Wrapper(impl)
}
