package zio.aws.finspace.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{
  IdType,
  EnvironmentArn,
  Timestamp,
  KxEnvironmentName,
  KmsKeyId,
  Description
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateKxEnvironmentResponse(
    name: Optional[KxEnvironmentName] = Optional.Absent,
    status: Optional[zio.aws.finspace.model.EnvironmentStatus] =
      Optional.Absent,
    environmentId: Optional[IdType] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    environmentArn: Optional[EnvironmentArn] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    creationTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.CreateKxEnvironmentResponse = {
    import CreateKxEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.CreateKxEnvironmentResponse
      .builder()
      .optionallyWith(
        name.map(value => KxEnvironmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        environmentId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.environmentId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environmentArn.map(value =>
          EnvironmentArn.unwrap(value): java.lang.String
        )
      )(_.environmentArn)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        creationTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.CreateKxEnvironmentResponse.ReadOnly =
    zio.aws.finspace.model.CreateKxEnvironmentResponse.wrap(buildAwsValue())
}
object CreateKxEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.CreateKxEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.CreateKxEnvironmentResponse =
      zio.aws.finspace.model.CreateKxEnvironmentResponse(
        name.map(value => value),
        status.map(value => value),
        environmentId.map(value => value),
        description.map(value => value),
        environmentArn.map(value => value),
        kmsKeyId.map(value => value),
        creationTimestamp.map(value => value)
      )
    def name: Optional[KxEnvironmentName]
    def status: Optional[zio.aws.finspace.model.EnvironmentStatus]
    def environmentId: Optional[IdType]
    def description: Optional[Description]
    def environmentArn: Optional[EnvironmentArn]
    def kmsKeyId: Optional[KmsKeyId]
    def creationTimestamp: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, KxEnvironmentName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.finspace.model.EnvironmentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getEnvironmentId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironmentArn: ZIO[Any, AwsError, EnvironmentArn] =
      AwsError.unwrapOptionField("environmentArn", environmentArn)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getCreationTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.CreateKxEnvironmentResponse
  ) extends zio.aws.finspace.model.CreateKxEnvironmentResponse.ReadOnly {
    override val name: Optional[KxEnvironmentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.finspace.model.primitives.KxEnvironmentName(value))
    override val status: Optional[zio.aws.finspace.model.EnvironmentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.finspace.model.EnvironmentStatus.wrap(value))
    override val environmentId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value => zio.aws.finspace.model.primitives.IdType(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.finspace.model.primitives.Description(value))
    override val environmentArn: Optional[EnvironmentArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentArn())
        .map(value => zio.aws.finspace.model.primitives.EnvironmentArn(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.finspace.model.primitives.KmsKeyId(value))
    override val creationTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimestamp())
      .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.CreateKxEnvironmentResponse
  ): zio.aws.finspace.model.CreateKxEnvironmentResponse.ReadOnly = new Wrapper(
    impl
  )
}
