package zio.aws.finspace
import zio.aws.finspace.model.CreateEnvironmentResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.finspace.FinspaceAsyncClient
import zio.aws.finspace.model.{
  DeleteKxUserRequest,
  GetKxDatabaseRequest,
  GetEnvironmentRequest,
  UpdateKxClusterDatabasesRequest,
  ListEnvironmentsRequest,
  ListKxClustersRequest,
  ListKxClusterNodesRequest,
  DeleteKxClusterRequest,
  DeleteKxEnvironmentRequest,
  UpdateKxDatabaseRequest,
  UpdateKxEnvironmentRequest,
  ListKxDatabasesRequest,
  UpdateEnvironmentRequest,
  CreateKxChangesetRequest,
  ListTagsForResourceRequest,
  CreateKxUserRequest,
  CreateKxClusterRequest,
  CreateKxDatabaseRequest,
  ListKxChangesetsRequest,
  GetKxChangesetRequest,
  GetKxClusterRequest,
  DeleteKxDatabaseRequest,
  UntagResourceRequest,
  UpdateKxUserRequest,
  GetKxEnvironmentRequest,
  ListKxEnvironmentsRequest,
  CreateEnvironmentRequest,
  CreateKxEnvironmentRequest,
  GetKxUserRequest,
  DeleteEnvironmentRequest,
  GetKxConnectionStringRequest,
  UpdateKxEnvironmentNetworkRequest,
  ListKxUsersRequest,
  TagResourceRequest
}
import zio.stream.ZStream
object FinspaceMock extends Mock[Finspace] {
  object DeleteEnvironment
      extends Effect[
        DeleteEnvironmentRequest,
        AwsError,
        zio.aws.finspace.model.DeleteEnvironmentResponse.ReadOnly
      ]
  object ListKxUsers
      extends Effect[
        ListKxUsersRequest,
        AwsError,
        zio.aws.finspace.model.ListKxUsersResponse.ReadOnly
      ]
  object GetKxDatabase
      extends Effect[
        GetKxDatabaseRequest,
        AwsError,
        zio.aws.finspace.model.GetKxDatabaseResponse.ReadOnly
      ]
  object ListKxDatabases
      extends Effect[
        ListKxDatabasesRequest,
        AwsError,
        zio.aws.finspace.model.ListKxDatabasesResponse.ReadOnly
      ]
  object GetKxConnectionString
      extends Effect[
        GetKxConnectionStringRequest,
        AwsError,
        zio.aws.finspace.model.GetKxConnectionStringResponse.ReadOnly
      ]
  object UpdateKxDatabase
      extends Effect[
        UpdateKxDatabaseRequest,
        AwsError,
        zio.aws.finspace.model.UpdateKxDatabaseResponse.ReadOnly
      ]
  object UpdateKxEnvironment
      extends Effect[
        UpdateKxEnvironmentRequest,
        AwsError,
        zio.aws.finspace.model.UpdateKxEnvironmentResponse.ReadOnly
      ]
  object CreateEnvironment
      extends Effect[CreateEnvironmentRequest, AwsError, ReadOnly]
  object CreateKxDatabase
      extends Effect[
        CreateKxDatabaseRequest,
        AwsError,
        zio.aws.finspace.model.CreateKxDatabaseResponse.ReadOnly
      ]
  object CreateKxEnvironment
      extends Effect[
        CreateKxEnvironmentRequest,
        AwsError,
        zio.aws.finspace.model.CreateKxEnvironmentResponse.ReadOnly
      ]
  object GetEnvironment
      extends Effect[
        GetEnvironmentRequest,
        AwsError,
        zio.aws.finspace.model.GetEnvironmentResponse.ReadOnly
      ]
  object ListKxClusters
      extends Effect[
        ListKxClustersRequest,
        AwsError,
        zio.aws.finspace.model.ListKxClustersResponse.ReadOnly
      ]
  object GetKxCluster
      extends Effect[
        GetKxClusterRequest,
        AwsError,
        zio.aws.finspace.model.GetKxClusterResponse.ReadOnly
      ]
  object UpdateKxEnvironmentNetwork
      extends Effect[
        UpdateKxEnvironmentNetworkRequest,
        AwsError,
        zio.aws.finspace.model.UpdateKxEnvironmentNetworkResponse.ReadOnly
      ]
  object CreateKxCluster
      extends Effect[
        CreateKxClusterRequest,
        AwsError,
        zio.aws.finspace.model.CreateKxClusterResponse.ReadOnly
      ]
  object GetKxChangeset
      extends Effect[
        GetKxChangesetRequest,
        AwsError,
        zio.aws.finspace.model.GetKxChangesetResponse.ReadOnly
      ]
  object CreateKxUser
      extends Effect[
        CreateKxUserRequest,
        AwsError,
        zio.aws.finspace.model.CreateKxUserResponse.ReadOnly
      ]
  object GetKxEnvironment
      extends Effect[
        GetKxEnvironmentRequest,
        AwsError,
        zio.aws.finspace.model.GetKxEnvironmentResponse.ReadOnly
      ]
  object CreateKxChangeset
      extends Effect[
        CreateKxChangesetRequest,
        AwsError,
        zio.aws.finspace.model.CreateKxChangesetResponse.ReadOnly
      ]
  object UpdateKxClusterDatabases
      extends Effect[
        UpdateKxClusterDatabasesRequest,
        AwsError,
        zio.aws.finspace.model.UpdateKxClusterDatabasesResponse.ReadOnly
      ]
  object UpdateKxUser
      extends Effect[
        UpdateKxUserRequest,
        AwsError,
        zio.aws.finspace.model.UpdateKxUserResponse.ReadOnly
      ]
  object ListEnvironments
      extends Effect[
        ListEnvironmentsRequest,
        AwsError,
        zio.aws.finspace.model.ListEnvironmentsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.finspace.model.UntagResourceResponse.ReadOnly
      ]
  object ListKxClusterNodes
      extends Effect[
        ListKxClusterNodesRequest,
        AwsError,
        zio.aws.finspace.model.ListKxClusterNodesResponse.ReadOnly
      ]
  object GetKxUser
      extends Effect[
        GetKxUserRequest,
        AwsError,
        zio.aws.finspace.model.GetKxUserResponse.ReadOnly
      ]
  object DeleteKxDatabase
      extends Effect[
        DeleteKxDatabaseRequest,
        AwsError,
        zio.aws.finspace.model.DeleteKxDatabaseResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.finspace.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.finspace.model.TagResourceResponse.ReadOnly
      ]
  object ListKxChangesets
      extends Effect[
        ListKxChangesetsRequest,
        AwsError,
        zio.aws.finspace.model.ListKxChangesetsResponse.ReadOnly
      ]
  object UpdateEnvironment
      extends Effect[
        UpdateEnvironmentRequest,
        AwsError,
        zio.aws.finspace.model.UpdateEnvironmentResponse.ReadOnly
      ]
  object DeleteKxUser
      extends Effect[
        DeleteKxUserRequest,
        AwsError,
        zio.aws.finspace.model.DeleteKxUserResponse.ReadOnly
      ]
  object DeleteKxCluster
      extends Effect[
        DeleteKxClusterRequest,
        AwsError,
        zio.aws.finspace.model.DeleteKxClusterResponse.ReadOnly
      ]
  object ListKxEnvironments
      extends Stream[
        ListKxEnvironmentsRequest,
        AwsError,
        zio.aws.finspace.model.KxEnvironment.ReadOnly
      ]
  object ListKxEnvironmentsPaginated
      extends Effect[
        ListKxEnvironmentsRequest,
        AwsError,
        zio.aws.finspace.model.ListKxEnvironmentsResponse.ReadOnly
      ]
  object DeleteKxEnvironment
      extends Effect[
        DeleteKxEnvironmentRequest,
        AwsError,
        zio.aws.finspace.model.DeleteKxEnvironmentResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Finspace] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Finspace] { rts =>
        zio.ZIO.succeed {
          new Finspace {
            val api: FinspaceAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Finspace = this
            def deleteEnvironment(request: DeleteEnvironmentRequest): IO[
              AwsError,
              zio.aws.finspace.model.DeleteEnvironmentResponse.ReadOnly
            ] = proxy(DeleteEnvironment, request)
            def listKxUsers(request: ListKxUsersRequest): IO[
              AwsError,
              zio.aws.finspace.model.ListKxUsersResponse.ReadOnly
            ] = proxy(ListKxUsers, request)
            def getKxDatabase(request: GetKxDatabaseRequest): IO[
              AwsError,
              zio.aws.finspace.model.GetKxDatabaseResponse.ReadOnly
            ] = proxy(GetKxDatabase, request)
            def listKxDatabases(request: ListKxDatabasesRequest): IO[
              AwsError,
              zio.aws.finspace.model.ListKxDatabasesResponse.ReadOnly
            ] = proxy(ListKxDatabases, request)
            def getKxConnectionString(
                request: GetKxConnectionStringRequest
            ): IO[
              AwsError,
              zio.aws.finspace.model.GetKxConnectionStringResponse.ReadOnly
            ] = proxy(GetKxConnectionString, request)
            def updateKxDatabase(request: UpdateKxDatabaseRequest): IO[
              AwsError,
              zio.aws.finspace.model.UpdateKxDatabaseResponse.ReadOnly
            ] = proxy(UpdateKxDatabase, request)
            def updateKxEnvironment(request: UpdateKxEnvironmentRequest): IO[
              AwsError,
              zio.aws.finspace.model.UpdateKxEnvironmentResponse.ReadOnly
            ] = proxy(UpdateKxEnvironment, request)
            def createEnvironment(
                request: CreateEnvironmentRequest
            ): IO[AwsError, ReadOnly] = proxy(CreateEnvironment, request)
            def createKxDatabase(request: CreateKxDatabaseRequest): IO[
              AwsError,
              zio.aws.finspace.model.CreateKxDatabaseResponse.ReadOnly
            ] = proxy(CreateKxDatabase, request)
            def createKxEnvironment(request: CreateKxEnvironmentRequest): IO[
              AwsError,
              zio.aws.finspace.model.CreateKxEnvironmentResponse.ReadOnly
            ] = proxy(CreateKxEnvironment, request)
            def getEnvironment(request: GetEnvironmentRequest): IO[
              AwsError,
              zio.aws.finspace.model.GetEnvironmentResponse.ReadOnly
            ] = proxy(GetEnvironment, request)
            def listKxClusters(request: ListKxClustersRequest): IO[
              AwsError,
              zio.aws.finspace.model.ListKxClustersResponse.ReadOnly
            ] = proxy(ListKxClusters, request)
            def getKxCluster(request: GetKxClusterRequest): IO[
              AwsError,
              zio.aws.finspace.model.GetKxClusterResponse.ReadOnly
            ] = proxy(GetKxCluster, request)
            def updateKxEnvironmentNetwork(
                request: UpdateKxEnvironmentNetworkRequest
            ): IO[
              AwsError,
              zio.aws.finspace.model.UpdateKxEnvironmentNetworkResponse.ReadOnly
            ] = proxy(UpdateKxEnvironmentNetwork, request)
            def createKxCluster(request: CreateKxClusterRequest): IO[
              AwsError,
              zio.aws.finspace.model.CreateKxClusterResponse.ReadOnly
            ] = proxy(CreateKxCluster, request)
            def getKxChangeset(request: GetKxChangesetRequest): IO[
              AwsError,
              zio.aws.finspace.model.GetKxChangesetResponse.ReadOnly
            ] = proxy(GetKxChangeset, request)
            def createKxUser(request: CreateKxUserRequest): IO[
              AwsError,
              zio.aws.finspace.model.CreateKxUserResponse.ReadOnly
            ] = proxy(CreateKxUser, request)
            def getKxEnvironment(request: GetKxEnvironmentRequest): IO[
              AwsError,
              zio.aws.finspace.model.GetKxEnvironmentResponse.ReadOnly
            ] = proxy(GetKxEnvironment, request)
            def createKxChangeset(request: CreateKxChangesetRequest): IO[
              AwsError,
              zio.aws.finspace.model.CreateKxChangesetResponse.ReadOnly
            ] = proxy(CreateKxChangeset, request)
            def updateKxClusterDatabases(
                request: UpdateKxClusterDatabasesRequest
            ): IO[
              AwsError,
              zio.aws.finspace.model.UpdateKxClusterDatabasesResponse.ReadOnly
            ] = proxy(UpdateKxClusterDatabases, request)
            def updateKxUser(request: UpdateKxUserRequest): IO[
              AwsError,
              zio.aws.finspace.model.UpdateKxUserResponse.ReadOnly
            ] = proxy(UpdateKxUser, request)
            def listEnvironments(request: ListEnvironmentsRequest): IO[
              AwsError,
              zio.aws.finspace.model.ListEnvironmentsResponse.ReadOnly
            ] = proxy(ListEnvironments, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.finspace.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listKxClusterNodes(request: ListKxClusterNodesRequest): IO[
              AwsError,
              zio.aws.finspace.model.ListKxClusterNodesResponse.ReadOnly
            ] = proxy(ListKxClusterNodes, request)
            def getKxUser(
                request: GetKxUserRequest
            ): IO[AwsError, zio.aws.finspace.model.GetKxUserResponse.ReadOnly] =
              proxy(GetKxUser, request)
            def deleteKxDatabase(request: DeleteKxDatabaseRequest): IO[
              AwsError,
              zio.aws.finspace.model.DeleteKxDatabaseResponse.ReadOnly
            ] = proxy(DeleteKxDatabase, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.finspace.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.finspace.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listKxChangesets(request: ListKxChangesetsRequest): IO[
              AwsError,
              zio.aws.finspace.model.ListKxChangesetsResponse.ReadOnly
            ] = proxy(ListKxChangesets, request)
            def updateEnvironment(request: UpdateEnvironmentRequest): IO[
              AwsError,
              zio.aws.finspace.model.UpdateEnvironmentResponse.ReadOnly
            ] = proxy(UpdateEnvironment, request)
            def deleteKxUser(request: DeleteKxUserRequest): IO[
              AwsError,
              zio.aws.finspace.model.DeleteKxUserResponse.ReadOnly
            ] = proxy(DeleteKxUser, request)
            def deleteKxCluster(request: DeleteKxClusterRequest): IO[
              AwsError,
              zio.aws.finspace.model.DeleteKxClusterResponse.ReadOnly
            ] = proxy(DeleteKxCluster, request)
            def listKxEnvironments(request: ListKxEnvironmentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.finspace.model.KxEnvironment.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListKxEnvironments, request)
                }
                .getOrThrowFiberFailure()
            }
            def listKxEnvironmentsPaginated(
                request: ListKxEnvironmentsRequest
            ): IO[
              AwsError,
              zio.aws.finspace.model.ListKxEnvironmentsResponse.ReadOnly
            ] = proxy(ListKxEnvironmentsPaginated, request)
            def deleteKxEnvironment(request: DeleteKxEnvironmentRequest): IO[
              AwsError,
              zio.aws.finspace.model.DeleteKxEnvironmentResponse.ReadOnly
            ] = proxy(DeleteKxEnvironment, request)
          }
        }
      }
    }
  }
}
