package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{ValidCIDRSpace, TransitGatewayID}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TransitGatewayConfiguration(
    transitGatewayID: TransitGatewayID,
    routableCIDRSpace: ValidCIDRSpace
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.TransitGatewayConfiguration = {
    import TransitGatewayConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.TransitGatewayConfiguration
      .builder()
      .transitGatewayID(
        TransitGatewayID.unwrap(transitGatewayID): java.lang.String
      )
      .routableCIDRSpace(
        ValidCIDRSpace.unwrap(routableCIDRSpace): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.TransitGatewayConfiguration.ReadOnly =
    zio.aws.finspace.model.TransitGatewayConfiguration.wrap(buildAwsValue())
}
object TransitGatewayConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.TransitGatewayConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.TransitGatewayConfiguration =
      zio.aws.finspace.model
        .TransitGatewayConfiguration(transitGatewayID, routableCIDRSpace)
    def transitGatewayID: TransitGatewayID
    def routableCIDRSpace: ValidCIDRSpace
    def getTransitGatewayID: ZIO[Any, Nothing, TransitGatewayID] =
      ZIO.succeed(transitGatewayID)
    def getRoutableCIDRSpace: ZIO[Any, Nothing, ValidCIDRSpace] =
      ZIO.succeed(routableCIDRSpace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.TransitGatewayConfiguration
  ) extends zio.aws.finspace.model.TransitGatewayConfiguration.ReadOnly {
    override val transitGatewayID: TransitGatewayID =
      zio.aws.finspace.model.primitives
        .TransitGatewayID(impl.transitGatewayID())
    override val routableCIDRSpace: ValidCIDRSpace =
      zio.aws.finspace.model.primitives.ValidCIDRSpace(impl.routableCIDRSpace())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.TransitGatewayConfiguration
  ): zio.aws.finspace.model.TransitGatewayConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
