package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  KxCommandLineArgumentValue,
  KxCommandLineArgumentKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KxCommandLineArgument(
    key: Optional[KxCommandLineArgumentKey] = Optional.Absent,
    value: Optional[KxCommandLineArgumentValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.KxCommandLineArgument = {
    import KxCommandLineArgument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.KxCommandLineArgument
      .builder()
      .optionallyWith(
        key.map(value =>
          KxCommandLineArgumentKey.unwrap(value): java.lang.String
        )
      )(_.key)
      .optionallyWith(
        value.map(value =>
          KxCommandLineArgumentValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.KxCommandLineArgument.ReadOnly =
    zio.aws.finspace.model.KxCommandLineArgument.wrap(buildAwsValue())
}
object KxCommandLineArgument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.KxCommandLineArgument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.KxCommandLineArgument =
      zio.aws.finspace.model.KxCommandLineArgument(
        key.map(value => value),
        value.map(value => value)
      )
    def key: Optional[KxCommandLineArgumentKey]
    def value: Optional[KxCommandLineArgumentValue]
    def getKey: ZIO[Any, AwsError, KxCommandLineArgumentKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, KxCommandLineArgumentValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.KxCommandLineArgument
  ) extends zio.aws.finspace.model.KxCommandLineArgument.ReadOnly {
    override val key: Optional[KxCommandLineArgumentKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value =>
        zio.aws.finspace.model.primitives.KxCommandLineArgumentKey(value)
      )
    override val value: Optional[KxCommandLineArgumentValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          zio.aws.finspace.model.primitives.KxCommandLineArgumentValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.KxCommandLineArgument
  ): zio.aws.finspace.model.KxCommandLineArgument.ReadOnly = new Wrapper(impl)
}
