package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  SubnetIdString,
  SecurityGroupIdString,
  VpcIdString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcConfiguration(
    vpcId: Optional[VpcIdString] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupIdString]] =
      Optional.Absent,
    subnetIds: Optional[Iterable[SubnetIdString]] = Optional.Absent,
    ipAddressType: Optional[zio.aws.finspace.model.IPAddressType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.VpcConfiguration = {
    import VpcConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.VpcConfiguration
      .builder()
      .optionallyWith(
        vpcId.map(value => VpcIdString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupIdString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetIdString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.VpcConfiguration.ReadOnly =
    zio.aws.finspace.model.VpcConfiguration.wrap(buildAwsValue())
}
object VpcConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.VpcConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.VpcConfiguration =
      zio.aws.finspace.model.VpcConfiguration(
        vpcId.map(value => value),
        securityGroupIds.map(value => value),
        subnetIds.map(value => value),
        ipAddressType.map(value => value)
      )
    def vpcId: Optional[VpcIdString]
    def securityGroupIds: Optional[List[SecurityGroupIdString]]
    def subnetIds: Optional[List[SubnetIdString]]
    def ipAddressType: Optional[zio.aws.finspace.model.IPAddressType]
    def getVpcId: ZIO[Any, AwsError, VpcIdString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupIdString]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetIdString]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.finspace.model.IPAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.VpcConfiguration
  ) extends zio.aws.finspace.model.VpcConfiguration.ReadOnly {
    override val vpcId: Optional[VpcIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.finspace.model.primitives.VpcIdString(value))
    override val securityGroupIds: Optional[List[SecurityGroupIdString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspace.model.primitives.SecurityGroupIdString(item)
          }.toList
        )
    override val subnetIds: Optional[List[SubnetIdString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspace.model.primitives.SubnetIdString(item)
          }.toList
        )
    override val ipAddressType: Optional[zio.aws.finspace.model.IPAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value => zio.aws.finspace.model.IPAddressType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.VpcConfiguration
  ): zio.aws.finspace.model.VpcConfiguration.ReadOnly = new Wrapper(impl)
}
