package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  ClientToken,
  Description,
  KxEnvironmentName,
  IdType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateKxEnvironmentRequest(
    environmentId: IdType,
    name: Optional[KxEnvironmentName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentRequest = {
    import UpdateKxEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentRequest
      .builder()
      .environmentId(IdType.unwrap(environmentId): java.lang.String)
      .optionallyWith(
        name.map(value => KxEnvironmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.UpdateKxEnvironmentRequest.ReadOnly =
    zio.aws.finspace.model.UpdateKxEnvironmentRequest.wrap(buildAwsValue())
}
object UpdateKxEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.UpdateKxEnvironmentRequest =
      zio.aws.finspace.model.UpdateKxEnvironmentRequest(
        environmentId,
        name.map(value => value),
        description.map(value => value),
        clientToken.map(value => value)
      )
    def environmentId: IdType
    def name: Optional[KxEnvironmentName]
    def description: Optional[Description]
    def clientToken: Optional[ClientToken]
    def getEnvironmentId: ZIO[Any, Nothing, IdType] = ZIO.succeed(environmentId)
    def getName: ZIO[Any, AwsError, KxEnvironmentName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentRequest
  ) extends zio.aws.finspace.model.UpdateKxEnvironmentRequest.ReadOnly {
    override val environmentId: IdType =
      zio.aws.finspace.model.primitives.IdType(impl.environmentId())
    override val name: Optional[KxEnvironmentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.finspace.model.primitives.KxEnvironmentName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.finspace.model.primitives.Description(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.finspace.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentRequest
  ): zio.aws.finspace.model.UpdateKxEnvironmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
