package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{Description, EnvironmentName, IdType}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentRequest(
    environmentId: IdType,
    name: Optional[EnvironmentName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    federationMode: Optional[zio.aws.finspace.model.FederationMode] =
      Optional.Absent,
    federationParameters: Optional[
      zio.aws.finspace.model.FederationParameters
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.UpdateEnvironmentRequest = {
    import UpdateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.UpdateEnvironmentRequest
      .builder()
      .environmentId(IdType.unwrap(environmentId): java.lang.String)
      .optionallyWith(
        name.map(value => EnvironmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(federationMode.map(value => value.unwrap))(
        _.federationMode
      )
      .optionallyWith(federationParameters.map(value => value.buildAwsValue()))(
        _.federationParameters
      )
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.UpdateEnvironmentRequest.ReadOnly =
    zio.aws.finspace.model.UpdateEnvironmentRequest.wrap(buildAwsValue())
}
object UpdateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.UpdateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.UpdateEnvironmentRequest =
      zio.aws.finspace.model.UpdateEnvironmentRequest(
        environmentId,
        name.map(value => value),
        description.map(value => value),
        federationMode.map(value => value),
        federationParameters.map(value => value.asEditable)
      )
    def environmentId: IdType
    def name: Optional[EnvironmentName]
    def description: Optional[Description]
    def federationMode: Optional[zio.aws.finspace.model.FederationMode]
    def federationParameters
        : Optional[zio.aws.finspace.model.FederationParameters.ReadOnly]
    def getEnvironmentId: ZIO[Any, Nothing, IdType] = ZIO.succeed(environmentId)
    def getName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getFederationMode
        : ZIO[Any, AwsError, zio.aws.finspace.model.FederationMode] =
      AwsError.unwrapOptionField("federationMode", federationMode)
    def getFederationParameters: ZIO[
      Any,
      AwsError,
      zio.aws.finspace.model.FederationParameters.ReadOnly
    ] = AwsError.unwrapOptionField("federationParameters", federationParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.UpdateEnvironmentRequest
  ) extends zio.aws.finspace.model.UpdateEnvironmentRequest.ReadOnly {
    override val environmentId: IdType =
      zio.aws.finspace.model.primitives.IdType(impl.environmentId())
    override val name: Optional[EnvironmentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.finspace.model.primitives.EnvironmentName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.finspace.model.primitives.Description(value))
    override val federationMode
        : Optional[zio.aws.finspace.model.FederationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.federationMode())
        .map(value => zio.aws.finspace.model.FederationMode.wrap(value))
    override val federationParameters
        : Optional[zio.aws.finspace.model.FederationParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.federationParameters())
        .map(value => zio.aws.finspace.model.FederationParameters.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.UpdateEnvironmentRequest
  ): zio.aws.finspace.model.UpdateEnvironmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
