package zio.aws.finspace.model
import scala.jdk.CollectionConverters._
sealed trait TgwStatus {
  def unwrap: software.amazon.awssdk.services.finspace.model.TgwStatus
}
object TgwStatus {
  def wrap(
      value: software.amazon.awssdk.services.finspace.model.TgwStatus
  ): zio.aws.finspace.model.TgwStatus = value match {
    case software.amazon.awssdk.services.finspace.model.TgwStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspace.model.TgwStatus.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.finspace.model.TgwStatus.UPDATE_REQUESTED =>
      val r = UPDATE_REQUESTED
      r
    case software.amazon.awssdk.services.finspace.model.TgwStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.finspace.model.TgwStatus.FAILED_UPDATE =>
      val r = FAILED_UPDATE
      r
    case software.amazon.awssdk.services.finspace.model.TgwStatus.SUCCESSFULLY_UPDATED =>
      val r = SUCCESSFULLY_UPDATED
      r
  }
  case object unknownToSdkVersion extends zio.aws.finspace.model.TgwStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.TgwStatus =
      software.amazon.awssdk.services.finspace.model.TgwStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.finspace.model.TgwStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.TgwStatus =
      software.amazon.awssdk.services.finspace.model.TgwStatus.NONE
  }
  case object UPDATE_REQUESTED extends zio.aws.finspace.model.TgwStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.TgwStatus =
      software.amazon.awssdk.services.finspace.model.TgwStatus.UPDATE_REQUESTED
  }
  case object UPDATING extends zio.aws.finspace.model.TgwStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.TgwStatus =
      software.amazon.awssdk.services.finspace.model.TgwStatus.UPDATING
  }
  case object FAILED_UPDATE extends zio.aws.finspace.model.TgwStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.TgwStatus =
      software.amazon.awssdk.services.finspace.model.TgwStatus.FAILED_UPDATE
  }
  case object SUCCESSFULLY_UPDATED extends zio.aws.finspace.model.TgwStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.TgwStatus =
      software.amazon.awssdk.services.finspace.model.TgwStatus.SUCCESSFULLY_UPDATED
  }
}
