package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.SignedKxConnectionString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetKxConnectionStringResponse(
    signedConnectionString: Optional[SignedKxConnectionString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.GetKxConnectionStringResponse = {
    import GetKxConnectionStringResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.GetKxConnectionStringResponse
      .builder()
      .optionallyWith(
        signedConnectionString.map(value =>
          SignedKxConnectionString.unwrap(value): java.lang.String
        )
      )(_.signedConnectionString)
      .build()
  }
  def asReadOnly
      : zio.aws.finspace.model.GetKxConnectionStringResponse.ReadOnly =
    zio.aws.finspace.model.GetKxConnectionStringResponse.wrap(buildAwsValue())
}
object GetKxConnectionStringResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.GetKxConnectionStringResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.GetKxConnectionStringResponse =
      zio.aws.finspace.model.GetKxConnectionStringResponse(
        signedConnectionString.map(value => value)
      )
    def signedConnectionString: Optional[SignedKxConnectionString]
    def getSignedConnectionString
        : ZIO[Any, AwsError, SignedKxConnectionString] = AwsError
      .unwrapOptionField("signedConnectionString", signedConnectionString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.GetKxConnectionStringResponse
  ) extends zio.aws.finspace.model.GetKxConnectionStringResponse.ReadOnly {
    override val signedConnectionString: Optional[SignedKxConnectionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signedConnectionString())
        .map(value =>
          zio.aws.finspace.model.primitives.SignedKxConnectionString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.GetKxConnectionStringResponse
  ): zio.aws.finspace.model.GetKxConnectionStringResponse.ReadOnly =
    new Wrapper(impl)
}
