package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  ChangesetId,
  DatabaseName,
  EnvironmentId
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetKxChangesetRequest(
    environmentId: EnvironmentId,
    databaseName: DatabaseName,
    changesetId: ChangesetId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.GetKxChangesetRequest = {
    import GetKxChangesetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.GetKxChangesetRequest
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .databaseName(DatabaseName.unwrap(databaseName): java.lang.String)
      .changesetId(ChangesetId.unwrap(changesetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.GetKxChangesetRequest.ReadOnly =
    zio.aws.finspace.model.GetKxChangesetRequest.wrap(buildAwsValue())
}
object GetKxChangesetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.GetKxChangesetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.GetKxChangesetRequest =
      zio.aws.finspace.model
        .GetKxChangesetRequest(environmentId, databaseName, changesetId)
    def environmentId: EnvironmentId
    def databaseName: DatabaseName
    def changesetId: ChangesetId
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
    def getDatabaseName: ZIO[Any, Nothing, DatabaseName] =
      ZIO.succeed(databaseName)
    def getChangesetId: ZIO[Any, Nothing, ChangesetId] =
      ZIO.succeed(changesetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.GetKxChangesetRequest
  ) extends zio.aws.finspace.model.GetKxChangesetRequest.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.finspace.model.primitives.EnvironmentId(impl.environmentId())
    override val databaseName: DatabaseName =
      zio.aws.finspace.model.primitives.DatabaseName(impl.databaseName())
    override val changesetId: ChangesetId =
      zio.aws.finspace.model.primitives.ChangesetId(impl.changesetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.GetKxChangesetRequest
  ): zio.aws.finspace.model.GetKxChangesetRequest.ReadOnly = new Wrapper(impl)
}
