package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  ClientTokenString,
  KxClusterName,
  KxEnvironmentId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteKxClusterRequest(
    environmentId: KxEnvironmentId,
    clusterName: KxClusterName,
    clientToken: Optional[ClientTokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.DeleteKxClusterRequest = {
    import DeleteKxClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.DeleteKxClusterRequest
      .builder()
      .environmentId(KxEnvironmentId.unwrap(environmentId): java.lang.String)
      .clusterName(KxClusterName.unwrap(clusterName): java.lang.String)
      .optionallyWith(
        clientToken.map(value =>
          ClientTokenString.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.DeleteKxClusterRequest.ReadOnly =
    zio.aws.finspace.model.DeleteKxClusterRequest.wrap(buildAwsValue())
}
object DeleteKxClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.DeleteKxClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.DeleteKxClusterRequest =
      zio.aws.finspace.model.DeleteKxClusterRequest(
        environmentId,
        clusterName,
        clientToken.map(value => value)
      )
    def environmentId: KxEnvironmentId
    def clusterName: KxClusterName
    def clientToken: Optional[ClientTokenString]
    def getEnvironmentId: ZIO[Any, Nothing, KxEnvironmentId] =
      ZIO.succeed(environmentId)
    def getClusterName: ZIO[Any, Nothing, KxClusterName] =
      ZIO.succeed(clusterName)
    def getClientToken: ZIO[Any, AwsError, ClientTokenString] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.DeleteKxClusterRequest
  ) extends zio.aws.finspace.model.DeleteKxClusterRequest.ReadOnly {
    override val environmentId: KxEnvironmentId =
      zio.aws.finspace.model.primitives.KxEnvironmentId(impl.environmentId())
    override val clusterName: KxClusterName =
      zio.aws.finspace.model.primitives.KxClusterName(impl.clusterName())
    override val clientToken: Optional[ClientTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientToken())
        .map(value =>
          zio.aws.finspace.model.primitives.ClientTokenString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.DeleteKxClusterRequest
  ): zio.aws.finspace.model.DeleteKxClusterRequest.ReadOnly = new Wrapper(impl)
}
