package zio.aws.finspace.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{
  PaginationToken,
  MaxResults,
  KxEnvironmentId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListKxClustersRequest(
    environmentId: KxEnvironmentId,
    clusterType: Optional[zio.aws.finspace.model.KxClusterType] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.ListKxClustersRequest = {
    import ListKxClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.ListKxClustersRequest
      .builder()
      .environmentId(KxEnvironmentId.unwrap(environmentId): java.lang.String)
      .optionallyWith(clusterType.map(value => value.unwrap))(_.clusterType)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.ListKxClustersRequest.ReadOnly =
    zio.aws.finspace.model.ListKxClustersRequest.wrap(buildAwsValue())
}
object ListKxClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.ListKxClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.ListKxClustersRequest =
      zio.aws.finspace.model.ListKxClustersRequest(
        environmentId,
        clusterType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def environmentId: KxEnvironmentId
    def clusterType: Optional[zio.aws.finspace.model.KxClusterType]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def getEnvironmentId: ZIO[Any, Nothing, KxEnvironmentId] =
      ZIO.succeed(environmentId)
    def getClusterType
        : ZIO[Any, AwsError, zio.aws.finspace.model.KxClusterType] =
      AwsError.unwrapOptionField("clusterType", clusterType)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.ListKxClustersRequest
  ) extends zio.aws.finspace.model.ListKxClustersRequest.ReadOnly {
    override val environmentId: KxEnvironmentId =
      zio.aws.finspace.model.primitives.KxEnvironmentId(impl.environmentId())
    override val clusterType: Optional[zio.aws.finspace.model.KxClusterType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterType())
        .map(value => zio.aws.finspace.model.KxClusterType.wrap(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.finspace.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.finspace.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.ListKxClustersRequest
  ): zio.aws.finspace.model.ListKxClustersRequest.ReadOnly = new Wrapper(impl)
}
