package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListKxChangesetsResponse(
    kxChangesets: Optional[
      Iterable[zio.aws.finspace.model.KxChangesetListEntry]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.ListKxChangesetsResponse = {
    import ListKxChangesetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.ListKxChangesetsResponse
      .builder()
      .optionallyWith(
        kxChangesets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.kxChangesets)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.ListKxChangesetsResponse.ReadOnly =
    zio.aws.finspace.model.ListKxChangesetsResponse.wrap(buildAwsValue())
}
object ListKxChangesetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.ListKxChangesetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.ListKxChangesetsResponse =
      zio.aws.finspace.model.ListKxChangesetsResponse(
        kxChangesets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def kxChangesets
        : Optional[List[zio.aws.finspace.model.KxChangesetListEntry.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getKxChangesets: ZIO[Any, AwsError, List[
      zio.aws.finspace.model.KxChangesetListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("kxChangesets", kxChangesets)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.ListKxChangesetsResponse
  ) extends zio.aws.finspace.model.ListKxChangesetsResponse.ReadOnly {
    override val kxChangesets
        : Optional[List[zio.aws.finspace.model.KxChangesetListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kxChangesets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspace.model.KxChangesetListEntry.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.finspace.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.ListKxChangesetsResponse
  ): zio.aws.finspace.model.ListKxChangesetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
