package zio.aws.finspace.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{
  InitializationScriptFilePath,
  ExecutionRoleArn,
  AvailabilityZoneId,
  Timestamp,
  KxClusterDescription,
  KxClusterStatusReason,
  ReleaseLabel,
  KxClusterName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetKxClusterResponse(
    status: Optional[zio.aws.finspace.model.KxClusterStatus] = Optional.Absent,
    statusReason: Optional[KxClusterStatusReason] = Optional.Absent,
    clusterName: Optional[KxClusterName] = Optional.Absent,
    clusterType: Optional[zio.aws.finspace.model.KxClusterType] =
      Optional.Absent,
    databases: Optional[
      Iterable[zio.aws.finspace.model.KxDatabaseConfiguration]
    ] = Optional.Absent,
    cacheStorageConfigurations: Optional[
      Iterable[zio.aws.finspace.model.KxCacheStorageConfiguration]
    ] = Optional.Absent,
    autoScalingConfiguration: Optional[
      zio.aws.finspace.model.AutoScalingConfiguration
    ] = Optional.Absent,
    clusterDescription: Optional[KxClusterDescription] = Optional.Absent,
    capacityConfiguration: Optional[
      zio.aws.finspace.model.CapacityConfiguration
    ] = Optional.Absent,
    releaseLabel: Optional[ReleaseLabel] = Optional.Absent,
    vpcConfiguration: Optional[zio.aws.finspace.model.VpcConfiguration] =
      Optional.Absent,
    initializationScript: Optional[InitializationScriptFilePath] =
      Optional.Absent,
    commandLineArguments: Optional[
      Iterable[zio.aws.finspace.model.KxCommandLineArgument]
    ] = Optional.Absent,
    code: Optional[zio.aws.finspace.model.CodeConfiguration] = Optional.Absent,
    executionRole: Optional[ExecutionRoleArn] = Optional.Absent,
    lastModifiedTimestamp: Optional[Timestamp] = Optional.Absent,
    savedownStorageConfiguration: Optional[
      zio.aws.finspace.model.KxSavedownStorageConfiguration
    ] = Optional.Absent,
    azMode: Optional[zio.aws.finspace.model.KxAzMode] = Optional.Absent,
    availabilityZoneId: Optional[AvailabilityZoneId] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.GetKxClusterResponse = {
    import GetKxClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.GetKxClusterResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value =>
          KxClusterStatusReason.unwrap(value): java.lang.String
        )
      )(_.statusReason)
      .optionallyWith(
        clusterName.map(value => KxClusterName.unwrap(value): java.lang.String)
      )(_.clusterName)
      .optionallyWith(clusterType.map(value => value.unwrap))(_.clusterType)
      .optionallyWith(
        databases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.databases)
      .optionallyWith(
        cacheStorageConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheStorageConfigurations)
      .optionallyWith(
        autoScalingConfiguration.map(value => value.buildAwsValue())
      )(_.autoScalingConfiguration)
      .optionallyWith(
        clusterDescription.map(value =>
          KxClusterDescription.unwrap(value): java.lang.String
        )
      )(_.clusterDescription)
      .optionallyWith(
        capacityConfiguration.map(value => value.buildAwsValue())
      )(_.capacityConfiguration)
      .optionallyWith(
        releaseLabel.map(value => ReleaseLabel.unwrap(value): java.lang.String)
      )(_.releaseLabel)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(
        initializationScript.map(value =>
          InitializationScriptFilePath.unwrap(value): java.lang.String
        )
      )(_.initializationScript)
      .optionallyWith(
        commandLineArguments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commandLineArguments)
      .optionallyWith(code.map(value => value.buildAwsValue()))(_.code)
      .optionallyWith(
        executionRole.map(value =>
          ExecutionRoleArn.unwrap(value): java.lang.String
        )
      )(_.executionRole)
      .optionallyWith(
        lastModifiedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimestamp)
      .optionallyWith(
        savedownStorageConfiguration.map(value => value.buildAwsValue())
      )(_.savedownStorageConfiguration)
      .optionallyWith(azMode.map(value => value.unwrap))(_.azMode)
      .optionallyWith(
        availabilityZoneId.map(value =>
          AvailabilityZoneId.unwrap(value): java.lang.String
        )
      )(_.availabilityZoneId)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.GetKxClusterResponse.ReadOnly =
    zio.aws.finspace.model.GetKxClusterResponse.wrap(buildAwsValue())
}
object GetKxClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.GetKxClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.GetKxClusterResponse =
      zio.aws.finspace.model.GetKxClusterResponse(
        status.map(value => value),
        statusReason.map(value => value),
        clusterName.map(value => value),
        clusterType.map(value => value),
        databases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cacheStorageConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autoScalingConfiguration.map(value => value.asEditable),
        clusterDescription.map(value => value),
        capacityConfiguration.map(value => value.asEditable),
        releaseLabel.map(value => value),
        vpcConfiguration.map(value => value.asEditable),
        initializationScript.map(value => value),
        commandLineArguments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        code.map(value => value.asEditable),
        executionRole.map(value => value),
        lastModifiedTimestamp.map(value => value),
        savedownStorageConfiguration.map(value => value.asEditable),
        azMode.map(value => value),
        availabilityZoneId.map(value => value),
        createdTimestamp.map(value => value)
      )
    def status: Optional[zio.aws.finspace.model.KxClusterStatus]
    def statusReason: Optional[KxClusterStatusReason]
    def clusterName: Optional[KxClusterName]
    def clusterType: Optional[zio.aws.finspace.model.KxClusterType]
    def databases: Optional[
      List[zio.aws.finspace.model.KxDatabaseConfiguration.ReadOnly]
    ]
    def cacheStorageConfigurations: Optional[
      List[zio.aws.finspace.model.KxCacheStorageConfiguration.ReadOnly]
    ]
    def autoScalingConfiguration
        : Optional[zio.aws.finspace.model.AutoScalingConfiguration.ReadOnly]
    def clusterDescription: Optional[KxClusterDescription]
    def capacityConfiguration
        : Optional[zio.aws.finspace.model.CapacityConfiguration.ReadOnly]
    def releaseLabel: Optional[ReleaseLabel]
    def vpcConfiguration
        : Optional[zio.aws.finspace.model.VpcConfiguration.ReadOnly]
    def initializationScript: Optional[InitializationScriptFilePath]
    def commandLineArguments
        : Optional[List[zio.aws.finspace.model.KxCommandLineArgument.ReadOnly]]
    def code: Optional[zio.aws.finspace.model.CodeConfiguration.ReadOnly]
    def executionRole: Optional[ExecutionRoleArn]
    def lastModifiedTimestamp: Optional[Timestamp]
    def savedownStorageConfiguration: Optional[
      zio.aws.finspace.model.KxSavedownStorageConfiguration.ReadOnly
    ]
    def azMode: Optional[zio.aws.finspace.model.KxAzMode]
    def availabilityZoneId: Optional[AvailabilityZoneId]
    def createdTimestamp: Optional[Timestamp]
    def getStatus: ZIO[Any, AwsError, zio.aws.finspace.model.KxClusterStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, KxClusterStatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getClusterName: ZIO[Any, AwsError, KxClusterName] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getClusterType
        : ZIO[Any, AwsError, zio.aws.finspace.model.KxClusterType] =
      AwsError.unwrapOptionField("clusterType", clusterType)
    def getDatabases: ZIO[Any, AwsError, List[
      zio.aws.finspace.model.KxDatabaseConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("databases", databases)
    def getCacheStorageConfigurations: ZIO[Any, AwsError, List[
      zio.aws.finspace.model.KxCacheStorageConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cacheStorageConfigurations",
      cacheStorageConfigurations
    )
    def getAutoScalingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.finspace.model.AutoScalingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoScalingConfiguration",
      autoScalingConfiguration
    )
    def getClusterDescription: ZIO[Any, AwsError, KxClusterDescription] =
      AwsError.unwrapOptionField("clusterDescription", clusterDescription)
    def getCapacityConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.finspace.model.CapacityConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("capacityConfiguration", capacityConfiguration)
    def getReleaseLabel: ZIO[Any, AwsError, ReleaseLabel] =
      AwsError.unwrapOptionField("releaseLabel", releaseLabel)
    def getVpcConfiguration
        : ZIO[Any, AwsError, zio.aws.finspace.model.VpcConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getInitializationScript
        : ZIO[Any, AwsError, InitializationScriptFilePath] =
      AwsError.unwrapOptionField("initializationScript", initializationScript)
    def getCommandLineArguments: ZIO[Any, AwsError, List[
      zio.aws.finspace.model.KxCommandLineArgument.ReadOnly
    ]] =
      AwsError.unwrapOptionField("commandLineArguments", commandLineArguments)
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.finspace.model.CodeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("code", code)
    def getExecutionRole: ZIO[Any, AwsError, ExecutionRoleArn] =
      AwsError.unwrapOptionField("executionRole", executionRole)
    def getLastModifiedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimestamp", lastModifiedTimestamp)
    def getSavedownStorageConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.finspace.model.KxSavedownStorageConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "savedownStorageConfiguration",
      savedownStorageConfiguration
    )
    def getAzMode: ZIO[Any, AwsError, zio.aws.finspace.model.KxAzMode] =
      AwsError.unwrapOptionField("azMode", azMode)
    def getAvailabilityZoneId: ZIO[Any, AwsError, AvailabilityZoneId] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.GetKxClusterResponse
  ) extends zio.aws.finspace.model.GetKxClusterResponse.ReadOnly {
    override val status: Optional[zio.aws.finspace.model.KxClusterStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.finspace.model.KxClusterStatus.wrap(value))
    override val statusReason: Optional[KxClusterStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusReason())
        .map(value =>
          zio.aws.finspace.model.primitives.KxClusterStatusReason(value)
        )
    override val clusterName: Optional[KxClusterName] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => zio.aws.finspace.model.primitives.KxClusterName(value))
    override val clusterType: Optional[zio.aws.finspace.model.KxClusterType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterType())
        .map(value => zio.aws.finspace.model.KxClusterType.wrap(value))
    override val databases: Optional[
      List[zio.aws.finspace.model.KxDatabaseConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.databases())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.finspace.model.KxDatabaseConfiguration.wrap(item)
        }.toList
      )
    override val cacheStorageConfigurations: Optional[
      List[zio.aws.finspace.model.KxCacheStorageConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheStorageConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.finspace.model.KxCacheStorageConfiguration.wrap(item)
        }.toList
      )
    override val autoScalingConfiguration
        : Optional[zio.aws.finspace.model.AutoScalingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingConfiguration())
        .map(value =>
          zio.aws.finspace.model.AutoScalingConfiguration.wrap(value)
        )
    override val clusterDescription: Optional[KxClusterDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterDescription())
        .map(value =>
          zio.aws.finspace.model.primitives.KxClusterDescription(value)
        )
    override val capacityConfiguration
        : Optional[zio.aws.finspace.model.CapacityConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityConfiguration())
        .map(value => zio.aws.finspace.model.CapacityConfiguration.wrap(value))
    override val releaseLabel: Optional[ReleaseLabel] = zio.aws.core.internal
      .optionalFromNullable(impl.releaseLabel())
      .map(value => zio.aws.finspace.model.primitives.ReleaseLabel(value))
    override val vpcConfiguration
        : Optional[zio.aws.finspace.model.VpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value => zio.aws.finspace.model.VpcConfiguration.wrap(value))
    override val initializationScript: Optional[InitializationScriptFilePath] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initializationScript())
        .map(value =>
          zio.aws.finspace.model.primitives.InitializationScriptFilePath(value)
        )
    override val commandLineArguments: Optional[
      List[zio.aws.finspace.model.KxCommandLineArgument.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.commandLineArguments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.finspace.model.KxCommandLineArgument.wrap(item)
        }.toList
      )
    override val code
        : Optional[zio.aws.finspace.model.CodeConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value => zio.aws.finspace.model.CodeConfiguration.wrap(value))
    override val executionRole: Optional[ExecutionRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionRole())
        .map(value => zio.aws.finspace.model.primitives.ExecutionRoleArn(value))
    override val lastModifiedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimestamp())
        .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
    override val savedownStorageConfiguration: Optional[
      zio.aws.finspace.model.KxSavedownStorageConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.savedownStorageConfiguration())
      .map(value =>
        zio.aws.finspace.model.KxSavedownStorageConfiguration.wrap(value)
      )
    override val azMode: Optional[zio.aws.finspace.model.KxAzMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.azMode())
        .map(value => zio.aws.finspace.model.KxAzMode.wrap(value))
    override val availabilityZoneId: Optional[AvailabilityZoneId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZoneId())
        .map(value =>
          zio.aws.finspace.model.primitives.AvailabilityZoneId(value)
        )
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.GetKxClusterResponse
  ): zio.aws.finspace.model.GetKxClusterResponse.ReadOnly = new Wrapper(impl)
}
