package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{ValidIPAddress, ValidHostname}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CustomDNSServer(
    customDNSServerName: ValidHostname,
    customDNSServerIP: ValidIPAddress
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.CustomDNSServer = {
    import CustomDNSServer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.CustomDNSServer
      .builder()
      .customDNSServerName(
        ValidHostname.unwrap(customDNSServerName): java.lang.String
      )
      .customDNSServerIP(
        ValidIPAddress.unwrap(customDNSServerIP): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.CustomDNSServer.ReadOnly =
    zio.aws.finspace.model.CustomDNSServer.wrap(buildAwsValue())
}
object CustomDNSServer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.CustomDNSServer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.CustomDNSServer =
      zio.aws.finspace.model
        .CustomDNSServer(customDNSServerName, customDNSServerIP)
    def customDNSServerName: ValidHostname
    def customDNSServerIP: ValidIPAddress
    def getCustomDNSServerName: ZIO[Any, Nothing, ValidHostname] =
      ZIO.succeed(customDNSServerName)
    def getCustomDNSServerIP: ZIO[Any, Nothing, ValidIPAddress] =
      ZIO.succeed(customDNSServerIP)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.CustomDNSServer
  ) extends zio.aws.finspace.model.CustomDNSServer.ReadOnly {
    override val customDNSServerName: ValidHostname =
      zio.aws.finspace.model.primitives
        .ValidHostname(impl.customDNSServerName())
    override val customDNSServerIP: ValidIPAddress =
      zio.aws.finspace.model.primitives.ValidIPAddress(impl.customDNSServerIP())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.CustomDNSServer
  ): zio.aws.finspace.model.CustomDNSServer.ReadOnly = new Wrapper(impl)
}
