package zio.aws.finspace.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{
  Timestamp,
  EnvironmentId,
  Description,
  DatabaseName,
  DatabaseArn
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateKxDatabaseResponse(
    databaseName: Optional[DatabaseName] = Optional.Absent,
    databaseArn: Optional[DatabaseArn] = Optional.Absent,
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    lastModifiedTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.CreateKxDatabaseResponse = {
    import CreateKxDatabaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.CreateKxDatabaseResponse
      .builder()
      .optionallyWith(
        databaseName.map(value => DatabaseName.unwrap(value): java.lang.String)
      )(_.databaseName)
      .optionallyWith(
        databaseArn.map(value => DatabaseArn.unwrap(value): java.lang.String)
      )(_.databaseArn)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastModifiedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.CreateKxDatabaseResponse.ReadOnly =
    zio.aws.finspace.model.CreateKxDatabaseResponse.wrap(buildAwsValue())
}
object CreateKxDatabaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.CreateKxDatabaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.CreateKxDatabaseResponse =
      zio.aws.finspace.model.CreateKxDatabaseResponse(
        databaseName.map(value => value),
        databaseArn.map(value => value),
        environmentId.map(value => value),
        description.map(value => value),
        createdTimestamp.map(value => value),
        lastModifiedTimestamp.map(value => value)
      )
    def databaseName: Optional[DatabaseName]
    def databaseArn: Optional[DatabaseArn]
    def environmentId: Optional[EnvironmentId]
    def description: Optional[Description]
    def createdTimestamp: Optional[Timestamp]
    def lastModifiedTimestamp: Optional[Timestamp]
    def getDatabaseName: ZIO[Any, AwsError, DatabaseName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDatabaseArn: ZIO[Any, AwsError, DatabaseArn] =
      AwsError.unwrapOptionField("databaseArn", databaseArn)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastModifiedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimestamp", lastModifiedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.CreateKxDatabaseResponse
  ) extends zio.aws.finspace.model.CreateKxDatabaseResponse.ReadOnly {
    override val databaseName: Optional[DatabaseName] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => zio.aws.finspace.model.primitives.DatabaseName(value))
    override val databaseArn: Optional[DatabaseArn] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseArn())
      .map(value => zio.aws.finspace.model.primitives.DatabaseArn(value))
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value => zio.aws.finspace.model.primitives.EnvironmentId(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.finspace.model.primitives.Description(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
    override val lastModifiedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimestamp())
        .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.CreateKxDatabaseResponse
  ): zio.aws.finspace.model.CreateKxDatabaseResponse.ReadOnly = new Wrapper(
    impl
  )
}
