package zio.aws.finspace.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{
  CooldownTime,
  AutoScalingMetricTarget,
  NodeCount
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AutoScalingConfiguration(
    minNodeCount: Optional[NodeCount] = Optional.Absent,
    maxNodeCount: Optional[NodeCount] = Optional.Absent,
    autoScalingMetric: Optional[zio.aws.finspace.model.AutoScalingMetric] =
      Optional.Absent,
    metricTarget: Optional[AutoScalingMetricTarget] = Optional.Absent,
    scaleInCooldownSeconds: Optional[CooldownTime] = Optional.Absent,
    scaleOutCooldownSeconds: Optional[CooldownTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.AutoScalingConfiguration = {
    import AutoScalingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.AutoScalingConfiguration
      .builder()
      .optionallyWith(
        minNodeCount.map(value => NodeCount.unwrap(value): Integer)
      )(_.minNodeCount)
      .optionallyWith(
        maxNodeCount.map(value => NodeCount.unwrap(value): Integer)
      )(_.maxNodeCount)
      .optionallyWith(autoScalingMetric.map(value => value.unwrap))(
        _.autoScalingMetric
      )
      .optionallyWith(
        metricTarget.map(value =>
          AutoScalingMetricTarget.unwrap(value): java.lang.Double
        )
      )(_.metricTarget)
      .optionallyWith(
        scaleInCooldownSeconds.map(value =>
          CooldownTime.unwrap(value): java.lang.Double
        )
      )(_.scaleInCooldownSeconds)
      .optionallyWith(
        scaleOutCooldownSeconds.map(value =>
          CooldownTime.unwrap(value): java.lang.Double
        )
      )(_.scaleOutCooldownSeconds)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.AutoScalingConfiguration.ReadOnly =
    zio.aws.finspace.model.AutoScalingConfiguration.wrap(buildAwsValue())
}
object AutoScalingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.AutoScalingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.AutoScalingConfiguration =
      zio.aws.finspace.model.AutoScalingConfiguration(
        minNodeCount.map(value => value),
        maxNodeCount.map(value => value),
        autoScalingMetric.map(value => value),
        metricTarget.map(value => value),
        scaleInCooldownSeconds.map(value => value),
        scaleOutCooldownSeconds.map(value => value)
      )
    def minNodeCount: Optional[NodeCount]
    def maxNodeCount: Optional[NodeCount]
    def autoScalingMetric: Optional[zio.aws.finspace.model.AutoScalingMetric]
    def metricTarget: Optional[AutoScalingMetricTarget]
    def scaleInCooldownSeconds: Optional[CooldownTime]
    def scaleOutCooldownSeconds: Optional[CooldownTime]
    def getMinNodeCount: ZIO[Any, AwsError, NodeCount] =
      AwsError.unwrapOptionField("minNodeCount", minNodeCount)
    def getMaxNodeCount: ZIO[Any, AwsError, NodeCount] =
      AwsError.unwrapOptionField("maxNodeCount", maxNodeCount)
    def getAutoScalingMetric
        : ZIO[Any, AwsError, zio.aws.finspace.model.AutoScalingMetric] =
      AwsError.unwrapOptionField("autoScalingMetric", autoScalingMetric)
    def getMetricTarget: ZIO[Any, AwsError, AutoScalingMetricTarget] =
      AwsError.unwrapOptionField("metricTarget", metricTarget)
    def getScaleInCooldownSeconds: ZIO[Any, AwsError, CooldownTime] = AwsError
      .unwrapOptionField("scaleInCooldownSeconds", scaleInCooldownSeconds)
    def getScaleOutCooldownSeconds: ZIO[Any, AwsError, CooldownTime] = AwsError
      .unwrapOptionField("scaleOutCooldownSeconds", scaleOutCooldownSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.AutoScalingConfiguration
  ) extends zio.aws.finspace.model.AutoScalingConfiguration.ReadOnly {
    override val minNodeCount: Optional[NodeCount] = zio.aws.core.internal
      .optionalFromNullable(impl.minNodeCount())
      .map(value => zio.aws.finspace.model.primitives.NodeCount(value))
    override val maxNodeCount: Optional[NodeCount] = zio.aws.core.internal
      .optionalFromNullable(impl.maxNodeCount())
      .map(value => zio.aws.finspace.model.primitives.NodeCount(value))
    override val autoScalingMetric
        : Optional[zio.aws.finspace.model.AutoScalingMetric] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingMetric())
        .map(value => zio.aws.finspace.model.AutoScalingMetric.wrap(value))
    override val metricTarget: Optional[AutoScalingMetricTarget] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricTarget())
        .map(value =>
          zio.aws.finspace.model.primitives.AutoScalingMetricTarget(value)
        )
    override val scaleInCooldownSeconds: Optional[CooldownTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scaleInCooldownSeconds())
        .map(value => zio.aws.finspace.model.primitives.CooldownTime(value))
    override val scaleOutCooldownSeconds: Optional[CooldownTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scaleOutCooldownSeconds())
        .map(value => zio.aws.finspace.model.primitives.CooldownTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.AutoScalingConfiguration
  ): zio.aws.finspace.model.AutoScalingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
