package zio.aws.finspace
import zio.prelude.Subtype
import zio.aws.finspace.model.primitives.{
  DataBundleArn,
  Url,
  TagValue,
  FederationAttributeKey,
  TagKey
}
import zio.aws.finspace.model.primitives.SmsDomainUrl.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object DataBundleArn extends Subtype[String]
    type DataBundleArn = zio.aws.finspace.model.primitives.DataBundleArn.Type
    object Description extends Subtype[String]
    type Description = zio.aws.finspace.model.primitives.Description.Type
    object EmailId extends Subtype[String]
    type EmailId = zio.aws.finspace.model.primitives.EmailId.Type
    object EnvironmentArn extends Subtype[String]
    type EnvironmentArn = zio.aws.finspace.model.primitives.EnvironmentArn.Type
    object EnvironmentName extends Subtype[String]
    type EnvironmentName =
      zio.aws.finspace.model.primitives.EnvironmentName.Type
    object FederationAttributeKey extends Subtype[String]
    type FederationAttributeKey =
      zio.aws.finspace.model.primitives.FederationAttributeKey.Type
    object FederationProviderName extends Subtype[String]
    type FederationProviderName =
      zio.aws.finspace.model.primitives.FederationProviderName.Type
    object IdType extends Subtype[String]
    type IdType = zio.aws.finspace.model.primitives.IdType.Type
    object KmsKeyId extends Subtype[String]
    type KmsKeyId = zio.aws.finspace.model.primitives.KmsKeyId.Type
    object NameString extends Subtype[String]
    type NameString = zio.aws.finspace.model.primitives.NameString.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.finspace.model.primitives.PaginationToken.Type
    object ResultLimit extends Subtype[Int]
    type ResultLimit = zio.aws.finspace.model.primitives.ResultLimit.Type
    object SamlMetadataDocument extends Subtype[String]
    type SamlMetadataDocument =
      zio.aws.finspace.model.primitives.SamlMetadataDocument.Type
    object SmsDomainUrl extends Subtype[String]
    type SmsDomainUrl = zio.aws.finspace.model.primitives.SmsDomainUrl.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.finspace.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.finspace.model.primitives.TagValue.Type
    object Url extends Subtype[String]
    type Url = zio.aws.finspace.model.primitives.Url.Type
    object Urn extends Subtype[String]
    type Urn = zio.aws.finspace.model.primitives.Urn.Type
  }
  type AttributeMap = Map[FederationAttributeKey, Url]
  type DataBundleArns = List[DataBundleArn]
  type EnvironmentList = List[zio.aws.finspace.model.Environment]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
}
