package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEnvironmentsResponse(
    environments: Optional[Iterable[zio.aws.finspace.model.Environment]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.ListEnvironmentsResponse = {
    import ListEnvironmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.ListEnvironmentsResponse
      .builder()
      .optionallyWith(
        environments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environments)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.ListEnvironmentsResponse.ReadOnly =
    zio.aws.finspace.model.ListEnvironmentsResponse.wrap(buildAwsValue())
}
object ListEnvironmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.ListEnvironmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.ListEnvironmentsResponse =
      zio.aws.finspace.model.ListEnvironmentsResponse(
        environments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def environments
        : Optional[List[zio.aws.finspace.model.Environment.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getEnvironments: ZIO[Any, AwsError, List[
      zio.aws.finspace.model.Environment.ReadOnly
    ]] = AwsError.unwrapOptionField("environments", environments)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.ListEnvironmentsResponse
  ) extends zio.aws.finspace.model.ListEnvironmentsResponse.ReadOnly {
    override val environments
        : Optional[List[zio.aws.finspace.model.Environment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspace.model.Environment.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.finspace.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.ListEnvironmentsResponse
  ): zio.aws.finspace.model.ListEnvironmentsResponse.ReadOnly = new Wrapper(
    impl
  )
}
