package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{Url, EnvironmentArn, IdType}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateEnvironmentResponse(
    environmentId: Optional[IdType] = Optional.Absent,
    environmentArn: Optional[EnvironmentArn] = Optional.Absent,
    environmentUrl: Optional[Url] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.CreateEnvironmentResponse = {
    import CreateEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.CreateEnvironmentResponse
      .builder()
      .optionallyWith(
        environmentId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.environmentId)
      .optionallyWith(
        environmentArn.map(value =>
          EnvironmentArn.unwrap(value): java.lang.String
        )
      )(_.environmentArn)
      .optionallyWith(
        environmentUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.environmentUrl)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.CreateEnvironmentResponse.ReadOnly =
    zio.aws.finspace.model.CreateEnvironmentResponse.wrap(buildAwsValue())
}
object CreateEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.CreateEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.CreateEnvironmentResponse =
      zio.aws.finspace.model.CreateEnvironmentResponse(
        environmentId.map(value => value),
        environmentArn.map(value => value),
        environmentUrl.map(value => value)
      )
    def environmentId: Optional[IdType]
    def environmentArn: Optional[EnvironmentArn]
    def environmentUrl: Optional[Url]
    def getEnvironmentId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getEnvironmentArn: ZIO[Any, AwsError, EnvironmentArn] =
      AwsError.unwrapOptionField("environmentArn", environmentArn)
    def getEnvironmentUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("environmentUrl", environmentUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.CreateEnvironmentResponse
  ) extends zio.aws.finspace.model.CreateEnvironmentResponse.ReadOnly {
    override val environmentId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value => zio.aws.finspace.model.primitives.IdType(value))
    override val environmentArn: Optional[EnvironmentArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentArn())
        .map(value => zio.aws.finspace.model.primitives.EnvironmentArn(value))
    override val environmentUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentUrl())
      .map(value => zio.aws.finspace.model.primitives.Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.CreateEnvironmentResponse
  ): zio.aws.finspace.model.CreateEnvironmentResponse.ReadOnly = new Wrapper(
    impl
  )
}
