package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.EnvironmentArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: EnvironmentArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(EnvironmentArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.finspace.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.ListTagsForResourceRequest =
      zio.aws.finspace.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: EnvironmentArn
    def getResourceArn: ZIO[Any, Nothing, EnvironmentArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.ListTagsForResourceRequest
  ) extends zio.aws.finspace.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: EnvironmentArn =
      zio.aws.finspace.model.primitives.EnvironmentArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.ListTagsForResourceRequest
  ): zio.aws.finspace.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
