package zio.aws.finspace
import zio.aws.finspace.model.CreateEnvironmentResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.finspace.model.{
  GetEnvironmentRequest,
  ListEnvironmentsRequest,
  GetEnvironmentResponse,
  UpdateEnvironmentRequest,
  ListTagsForResourceRequest,
  UpdateEnvironmentResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  UntagResourceRequest,
  CreateEnvironmentRequest,
  DeleteEnvironmentRequest,
  TagResourceResponse,
  ListEnvironmentsResponse,
  CreateEnvironmentResponse,
  TagResourceRequest,
  DeleteEnvironmentResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.finspace.{
  FinspaceAsyncClientBuilder,
  FinspaceAsyncClient
}
import scala.jdk.CollectionConverters._
trait Finspace extends AspectSupport[Finspace] {
  val api: FinspaceAsyncClient
  def deleteEnvironment(
      request: zio.aws.finspace.model.DeleteEnvironmentRequest
  ): IO[AwsError, zio.aws.finspace.model.DeleteEnvironmentResponse.ReadOnly]
  def createEnvironment(
      request: zio.aws.finspace.model.CreateEnvironmentRequest
  ): IO[AwsError, ReadOnly]
  def getEnvironment(
      request: zio.aws.finspace.model.GetEnvironmentRequest
  ): IO[AwsError, zio.aws.finspace.model.GetEnvironmentResponse.ReadOnly]
  def listEnvironments(
      request: zio.aws.finspace.model.ListEnvironmentsRequest
  ): IO[AwsError, zio.aws.finspace.model.ListEnvironmentsResponse.ReadOnly]
  def untagResource(
      request: zio.aws.finspace.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.finspace.model.UntagResourceResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.finspace.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.finspace.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: zio.aws.finspace.model.TagResourceRequest
  ): IO[AwsError, zio.aws.finspace.model.TagResourceResponse.ReadOnly]
  def updateEnvironment(
      request: zio.aws.finspace.model.UpdateEnvironmentRequest
  ): IO[AwsError, zio.aws.finspace.model.UpdateEnvironmentResponse.ReadOnly]
}
object Finspace {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Finspace] = customized(
    identity
  )
  def customized(
      customization: FinspaceAsyncClientBuilder => FinspaceAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Finspace] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: FinspaceAsyncClientBuilder => FinspaceAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Finspace] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = FinspaceAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[FinspaceAsyncClient, FinspaceAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[FinspaceAsyncClient, FinspaceAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new FinspaceImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class FinspaceImpl[R](
      override val api: FinspaceAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Finspace
      with AwsServiceBase[R] {
    override val serviceName: String = "Finspace"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): FinspaceImpl[R1] = new FinspaceImpl(api, newAspect, r)
    def deleteEnvironment(
        request: zio.aws.finspace.model.DeleteEnvironmentRequest
    ): IO[AwsError, zio.aws.finspace.model.DeleteEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[DeleteEnvironmentRequest, DeleteEnvironmentResponse](
        "deleteEnvironment",
        api.deleteEnvironment
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.DeleteEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def createEnvironment(
        request: zio.aws.finspace.model.CreateEnvironmentRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[CreateEnvironmentRequest, CreateEnvironmentResponse](
        "createEnvironment",
        api.createEnvironment
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.CreateEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def getEnvironment(
        request: zio.aws.finspace.model.GetEnvironmentRequest
    ): IO[AwsError, zio.aws.finspace.model.GetEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[GetEnvironmentRequest, GetEnvironmentResponse](
        "getEnvironment",
        api.getEnvironment
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.GetEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def listEnvironments(
        request: zio.aws.finspace.model.ListEnvironmentsRequest
    ): IO[AwsError, zio.aws.finspace.model.ListEnvironmentsResponse.ReadOnly] =
      asyncRequestResponse[ListEnvironmentsRequest, ListEnvironmentsResponse](
        "listEnvironments",
        api.listEnvironments
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.ListEnvironmentsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.finspace.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.finspace.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.finspace.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.finspace.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.finspace.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.finspace.model.TagResourceRequest
    ): IO[AwsError, zio.aws.finspace.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateEnvironment(
        request: zio.aws.finspace.model.UpdateEnvironmentRequest
    ): IO[AwsError, zio.aws.finspace.model.UpdateEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[UpdateEnvironmentRequest, UpdateEnvironmentResponse](
        "updateEnvironment",
        api.updateEnvironment
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.UpdateEnvironmentResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteEnvironment(
      request: zio.aws.finspace.model.DeleteEnvironmentRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.DeleteEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEnvironment(request))
  def createEnvironment(
      request: zio.aws.finspace.model.CreateEnvironmentRequest
  ): ZIO[zio.aws.finspace.Finspace, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createEnvironment(request))
  def getEnvironment(
      request: zio.aws.finspace.model.GetEnvironmentRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.GetEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEnvironment(request))
  def listEnvironments(
      request: zio.aws.finspace.model.ListEnvironmentsRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.ListEnvironmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnvironments(request))
  def untagResource(request: zio.aws.finspace.model.UntagResourceRequest): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listTagsForResource(
      request: zio.aws.finspace.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: zio.aws.finspace.model.TagResourceRequest): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateEnvironment(
      request: zio.aws.finspace.model.UpdateEnvironmentRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.UpdateEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEnvironment(request))
}
