package zio.aws.finspace.model
import scala.jdk.CollectionConverters._
sealed trait FederationMode {
  def unwrap: software.amazon.awssdk.services.finspace.model.FederationMode
}
object FederationMode {
  def wrap(
      value: software.amazon.awssdk.services.finspace.model.FederationMode
  ): zio.aws.finspace.model.FederationMode = value match {
    case software.amazon.awssdk.services.finspace.model.FederationMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspace.model.FederationMode.FEDERATED =>
      val r = FEDERATED
      r
    case software.amazon.awssdk.services.finspace.model.FederationMode.LOCAL =>
      val r = LOCAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.finspace.model.FederationMode {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.FederationMode =
      software.amazon.awssdk.services.finspace.model.FederationMode.UNKNOWN_TO_SDK_VERSION
  }
  case object FEDERATED extends zio.aws.finspace.model.FederationMode {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.FederationMode =
      software.amazon.awssdk.services.finspace.model.FederationMode.FEDERATED
  }
  case object LOCAL extends zio.aws.finspace.model.FederationMode {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.FederationMode =
      software.amazon.awssdk.services.finspace.model.FederationMode.LOCAL
  }
}
