package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  IdType,
  Url,
  EnvironmentArn,
  EnvironmentName,
  SmsDomainUrl,
  KmsKeyId,
  Description
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Environment(
    name: Optional[EnvironmentName] = Optional.Absent,
    environmentId: Optional[IdType] = Optional.Absent,
    awsAccountId: Optional[IdType] = Optional.Absent,
    status: Optional[zio.aws.finspace.model.EnvironmentStatus] =
      Optional.Absent,
    environmentUrl: Optional[Url] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    environmentArn: Optional[EnvironmentArn] = Optional.Absent,
    sageMakerStudioDomainUrl: Optional[SmsDomainUrl] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    dedicatedServiceAccountId: Optional[IdType] = Optional.Absent,
    federationMode: Optional[zio.aws.finspace.model.FederationMode] =
      Optional.Absent,
    federationParameters: Optional[
      zio.aws.finspace.model.FederationParameters
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.Environment = {
    import Environment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.Environment
      .builder()
      .optionallyWith(
        name.map(value => EnvironmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        environmentId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.environmentId)
      .optionallyWith(
        awsAccountId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.awsAccountId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        environmentUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.environmentUrl)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environmentArn.map(value =>
          EnvironmentArn.unwrap(value): java.lang.String
        )
      )(_.environmentArn)
      .optionallyWith(
        sageMakerStudioDomainUrl.map(value =>
          SmsDomainUrl.unwrap(value): java.lang.String
        )
      )(_.sageMakerStudioDomainUrl)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        dedicatedServiceAccountId.map(value =>
          IdType.unwrap(value): java.lang.String
        )
      )(_.dedicatedServiceAccountId)
      .optionallyWith(federationMode.map(value => value.unwrap))(
        _.federationMode
      )
      .optionallyWith(federationParameters.map(value => value.buildAwsValue()))(
        _.federationParameters
      )
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.Environment.ReadOnly =
    zio.aws.finspace.model.Environment.wrap(buildAwsValue())
}
object Environment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.Environment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.Environment =
      zio.aws.finspace.model.Environment(
        name.map(value => value),
        environmentId.map(value => value),
        awsAccountId.map(value => value),
        status.map(value => value),
        environmentUrl.map(value => value),
        description.map(value => value),
        environmentArn.map(value => value),
        sageMakerStudioDomainUrl.map(value => value),
        kmsKeyId.map(value => value),
        dedicatedServiceAccountId.map(value => value),
        federationMode.map(value => value),
        federationParameters.map(value => value.asEditable)
      )
    def name: Optional[EnvironmentName]
    def environmentId: Optional[IdType]
    def awsAccountId: Optional[IdType]
    def status: Optional[zio.aws.finspace.model.EnvironmentStatus]
    def environmentUrl: Optional[Url]
    def description: Optional[Description]
    def environmentArn: Optional[EnvironmentArn]
    def sageMakerStudioDomainUrl: Optional[SmsDomainUrl]
    def kmsKeyId: Optional[KmsKeyId]
    def dedicatedServiceAccountId: Optional[IdType]
    def federationMode: Optional[zio.aws.finspace.model.FederationMode]
    def federationParameters
        : Optional[zio.aws.finspace.model.FederationParameters.ReadOnly]
    def getName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("name", name)
    def getEnvironmentId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getAwsAccountId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.finspace.model.EnvironmentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getEnvironmentUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("environmentUrl", environmentUrl)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironmentArn: ZIO[Any, AwsError, EnvironmentArn] =
      AwsError.unwrapOptionField("environmentArn", environmentArn)
    def getSageMakerStudioDomainUrl: ZIO[Any, AwsError, SmsDomainUrl] = AwsError
      .unwrapOptionField("sageMakerStudioDomainUrl", sageMakerStudioDomainUrl)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDedicatedServiceAccountId: ZIO[Any, AwsError, IdType] = AwsError
      .unwrapOptionField("dedicatedServiceAccountId", dedicatedServiceAccountId)
    def getFederationMode
        : ZIO[Any, AwsError, zio.aws.finspace.model.FederationMode] =
      AwsError.unwrapOptionField("federationMode", federationMode)
    def getFederationParameters: ZIO[
      Any,
      AwsError,
      zio.aws.finspace.model.FederationParameters.ReadOnly
    ] = AwsError.unwrapOptionField("federationParameters", federationParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.Environment
  ) extends zio.aws.finspace.model.Environment.ReadOnly {
    override val name: Optional[EnvironmentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.finspace.model.primitives.EnvironmentName(value))
    override val environmentId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value => zio.aws.finspace.model.primitives.IdType(value))
    override val awsAccountId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => zio.aws.finspace.model.primitives.IdType(value))
    override val status: Optional[zio.aws.finspace.model.EnvironmentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.finspace.model.EnvironmentStatus.wrap(value))
    override val environmentUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentUrl())
      .map(value => zio.aws.finspace.model.primitives.Url(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.finspace.model.primitives.Description(value))
    override val environmentArn: Optional[EnvironmentArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentArn())
        .map(value => zio.aws.finspace.model.primitives.EnvironmentArn(value))
    override val sageMakerStudioDomainUrl: Optional[SmsDomainUrl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sageMakerStudioDomainUrl())
        .map(value => zio.aws.finspace.model.primitives.SmsDomainUrl(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.finspace.model.primitives.KmsKeyId(value))
    override val dedicatedServiceAccountId: Optional[IdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedServiceAccountId())
        .map(value => zio.aws.finspace.model.primitives.IdType(value))
    override val federationMode
        : Optional[zio.aws.finspace.model.FederationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.federationMode())
        .map(value => zio.aws.finspace.model.FederationMode.wrap(value))
    override val federationParameters
        : Optional[zio.aws.finspace.model.FederationParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.federationParameters())
        .map(value => zio.aws.finspace.model.FederationParameters.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.Environment
  ): zio.aws.finspace.model.Environment.ReadOnly = new Wrapper(impl)
}
