package zio.aws.finspace.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentResponse(
    environment: Option[zio.aws.finspace.model.Environment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.UpdateEnvironmentResponse = {
    import UpdateEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.UpdateEnvironmentResponse
      .builder()
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.UpdateEnvironmentResponse.ReadOnly =
    zio.aws.finspace.model.UpdateEnvironmentResponse.wrap(buildAwsValue())
}
object UpdateEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.UpdateEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.UpdateEnvironmentResponse =
      zio.aws.finspace.model
        .UpdateEnvironmentResponse(environment.map(value => value.asEditable))
    def environment: Option[zio.aws.finspace.model.Environment.ReadOnly]
    def getEnvironment
        : ZIO[Any, AwsError, zio.aws.finspace.model.Environment.ReadOnly] =
      AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.UpdateEnvironmentResponse
  ) extends zio.aws.finspace.model.UpdateEnvironmentResponse.ReadOnly {
    override val environment
        : Option[zio.aws.finspace.model.Environment.ReadOnly] = scala
      .Option(impl.environment())
      .map(value => zio.aws.finspace.model.Environment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.UpdateEnvironmentResponse
  ): zio.aws.finspace.model.UpdateEnvironmentResponse.ReadOnly = new Wrapper(
    impl
  )
}
