package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.IdType
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteEnvironmentRequest(environmentId: IdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.DeleteEnvironmentRequest = {
    import DeleteEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.DeleteEnvironmentRequest
      .builder()
      .environmentId(IdType.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.DeleteEnvironmentRequest.ReadOnly =
    zio.aws.finspace.model.DeleteEnvironmentRequest.wrap(buildAwsValue())
}
object DeleteEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.DeleteEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.DeleteEnvironmentRequest =
      zio.aws.finspace.model.DeleteEnvironmentRequest(environmentId)
    def environmentId: IdType
    def getEnvironmentId: ZIO[Any, Nothing, IdType] = ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.DeleteEnvironmentRequest
  ) extends zio.aws.finspace.model.DeleteEnvironmentRequest.ReadOnly {
    override val environmentId: IdType =
      zio.aws.finspace.model.primitives.IdType(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.DeleteEnvironmentRequest
  ): zio.aws.finspace.model.DeleteEnvironmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
