package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  IdType,
  Url,
  EnvironmentArn,
  EnvironmentName,
  SmsDomainUrl,
  KmsKeyId,
  Description
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Environment(
    name: Option[EnvironmentName] = None,
    environmentId: Option[IdType] = None,
    awsAccountId: Option[IdType] = None,
    status: Option[zio.aws.finspace.model.EnvironmentStatus] = None,
    environmentUrl: Option[Url] = None,
    description: Option[Description] = None,
    environmentArn: Option[EnvironmentArn] = None,
    sageMakerStudioDomainUrl: Option[SmsDomainUrl] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    dedicatedServiceAccountId: Option[IdType] = None,
    federationMode: Option[zio.aws.finspace.model.FederationMode] = None,
    federationParameters: Option[zio.aws.finspace.model.FederationParameters] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.Environment = {
    import Environment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.Environment
      .builder()
      .optionallyWith(
        name.map(value => EnvironmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        environmentId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.environmentId)
      .optionallyWith(
        awsAccountId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.awsAccountId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        environmentUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.environmentUrl)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environmentArn.map(value =>
          EnvironmentArn.unwrap(value): java.lang.String
        )
      )(_.environmentArn)
      .optionallyWith(
        sageMakerStudioDomainUrl.map(value =>
          SmsDomainUrl.unwrap(value): java.lang.String
        )
      )(_.sageMakerStudioDomainUrl)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        dedicatedServiceAccountId.map(value =>
          IdType.unwrap(value): java.lang.String
        )
      )(_.dedicatedServiceAccountId)
      .optionallyWith(federationMode.map(value => value.unwrap))(
        _.federationMode
      )
      .optionallyWith(federationParameters.map(value => value.buildAwsValue()))(
        _.federationParameters
      )
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.Environment.ReadOnly =
    zio.aws.finspace.model.Environment.wrap(buildAwsValue())
}
object Environment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.Environment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.Environment =
      zio.aws.finspace.model.Environment(
        name.map(value => value),
        environmentId.map(value => value),
        awsAccountId.map(value => value),
        status.map(value => value),
        environmentUrl.map(value => value),
        description.map(value => value),
        environmentArn.map(value => value),
        sageMakerStudioDomainUrl.map(value => value),
        kmsKeyId.map(value => value),
        dedicatedServiceAccountId.map(value => value),
        federationMode.map(value => value),
        federationParameters.map(value => value.asEditable)
      )
    def name: Option[EnvironmentName]
    def environmentId: Option[IdType]
    def awsAccountId: Option[IdType]
    def status: Option[zio.aws.finspace.model.EnvironmentStatus]
    def environmentUrl: Option[Url]
    def description: Option[Description]
    def environmentArn: Option[EnvironmentArn]
    def sageMakerStudioDomainUrl: Option[SmsDomainUrl]
    def kmsKeyId: Option[KmsKeyId]
    def dedicatedServiceAccountId: Option[IdType]
    def federationMode: Option[zio.aws.finspace.model.FederationMode]
    def federationParameters
        : Option[zio.aws.finspace.model.FederationParameters.ReadOnly]
    def getName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("name", name)
    def getEnvironmentId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getAwsAccountId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.finspace.model.EnvironmentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getEnvironmentUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("environmentUrl", environmentUrl)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironmentArn: ZIO[Any, AwsError, EnvironmentArn] =
      AwsError.unwrapOptionField("environmentArn", environmentArn)
    def getSageMakerStudioDomainUrl: ZIO[Any, AwsError, SmsDomainUrl] = AwsError
      .unwrapOptionField("sageMakerStudioDomainUrl", sageMakerStudioDomainUrl)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDedicatedServiceAccountId: ZIO[Any, AwsError, IdType] = AwsError
      .unwrapOptionField("dedicatedServiceAccountId", dedicatedServiceAccountId)
    def getFederationMode
        : ZIO[Any, AwsError, zio.aws.finspace.model.FederationMode] =
      AwsError.unwrapOptionField("federationMode", federationMode)
    def getFederationParameters: ZIO[
      Any,
      AwsError,
      zio.aws.finspace.model.FederationParameters.ReadOnly
    ] = AwsError.unwrapOptionField("federationParameters", federationParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.Environment
  ) extends zio.aws.finspace.model.Environment.ReadOnly {
    override val name: Option[EnvironmentName] = scala
      .Option(impl.name())
      .map(value => zio.aws.finspace.model.primitives.EnvironmentName(value))
    override val environmentId: Option[IdType] = scala
      .Option(impl.environmentId())
      .map(value => zio.aws.finspace.model.primitives.IdType(value))
    override val awsAccountId: Option[IdType] = scala
      .Option(impl.awsAccountId())
      .map(value => zio.aws.finspace.model.primitives.IdType(value))
    override val status: Option[zio.aws.finspace.model.EnvironmentStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.finspace.model.EnvironmentStatus.wrap(value))
    override val environmentUrl: Option[Url] = scala
      .Option(impl.environmentUrl())
      .map(value => zio.aws.finspace.model.primitives.Url(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.finspace.model.primitives.Description(value))
    override val environmentArn: Option[EnvironmentArn] = scala
      .Option(impl.environmentArn())
      .map(value => zio.aws.finspace.model.primitives.EnvironmentArn(value))
    override val sageMakerStudioDomainUrl: Option[SmsDomainUrl] = scala
      .Option(impl.sageMakerStudioDomainUrl())
      .map(value => zio.aws.finspace.model.primitives.SmsDomainUrl(value))
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.finspace.model.primitives.KmsKeyId(value))
    override val dedicatedServiceAccountId: Option[IdType] = scala
      .Option(impl.dedicatedServiceAccountId())
      .map(value => zio.aws.finspace.model.primitives.IdType(value))
    override val federationMode: Option[zio.aws.finspace.model.FederationMode] =
      scala
        .Option(impl.federationMode())
        .map(value => zio.aws.finspace.model.FederationMode.wrap(value))
    override val federationParameters
        : Option[zio.aws.finspace.model.FederationParameters.ReadOnly] = scala
      .Option(impl.federationParameters())
      .map(value => zio.aws.finspace.model.FederationParameters.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.Environment
  ): zio.aws.finspace.model.Environment.ReadOnly = new Wrapper(impl)
}
