package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{NameString, EmailId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SuperuserParameters(
    emailAddress: EmailId,
    firstName: NameString,
    lastName: NameString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.SuperuserParameters = {
    import SuperuserParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.SuperuserParameters
      .builder()
      .emailAddress(EmailId.unwrap(emailAddress): java.lang.String)
      .firstName(NameString.unwrap(firstName): java.lang.String)
      .lastName(NameString.unwrap(lastName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.SuperuserParameters.ReadOnly =
    zio.aws.finspace.model.SuperuserParameters.wrap(buildAwsValue())
}
object SuperuserParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.SuperuserParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.SuperuserParameters =
      zio.aws.finspace.model
        .SuperuserParameters(emailAddress, firstName, lastName)
    def emailAddress: EmailId
    def firstName: NameString
    def lastName: NameString
    def getEmailAddress: ZIO[Any, Nothing, EmailId] = ZIO.succeed(emailAddress)
    def getFirstName: ZIO[Any, Nothing, NameString] = ZIO.succeed(firstName)
    def getLastName: ZIO[Any, Nothing, NameString] = ZIO.succeed(lastName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.SuperuserParameters
  ) extends zio.aws.finspace.model.SuperuserParameters.ReadOnly {
    override val emailAddress: EmailId =
      zio.aws.finspace.model.primitives.EmailId(impl.emailAddress())
    override val firstName: NameString =
      zio.aws.finspace.model.primitives.NameString(impl.firstName())
    override val lastName: NameString =
      zio.aws.finspace.model.primitives.NameString(impl.lastName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.SuperuserParameters
  ): zio.aws.finspace.model.SuperuserParameters.ReadOnly = new Wrapper(impl)
}
