package zio.aws.finspace
import zio.aws.finspace.model.CreateEnvironmentResponse.ReadOnly
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.finspace.FinspaceAsyncClient
import zio.aws.finspace.model.{
  GetEnvironmentRequest,
  ListEnvironmentsRequest,
  UpdateEnvironmentRequest,
  ListTagsForResourceRequest,
  UntagResourceRequest,
  CreateEnvironmentRequest,
  DeleteEnvironmentRequest,
  TagResourceRequest
}
import zio.test.mock.{Proxy, Mock}
object FinspaceMock extends Mock[Finspace] {
  object DeleteEnvironment
      extends Effect[
        DeleteEnvironmentRequest,
        AwsError,
        zio.aws.finspace.model.DeleteEnvironmentResponse.ReadOnly
      ]
  object CreateEnvironment
      extends Effect[CreateEnvironmentRequest, AwsError, ReadOnly]
  object GetEnvironment
      extends Effect[
        GetEnvironmentRequest,
        AwsError,
        zio.aws.finspace.model.GetEnvironmentResponse.ReadOnly
      ]
  object ListEnvironments
      extends Effect[
        ListEnvironmentsRequest,
        AwsError,
        zio.aws.finspace.model.ListEnvironmentsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.finspace.model.UntagResourceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.finspace.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.finspace.model.TagResourceResponse.ReadOnly
      ]
  object UpdateEnvironment
      extends Effect[
        UpdateEnvironmentRequest,
        AwsError,
        zio.aws.finspace.model.UpdateEnvironmentResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Finspace] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Finspace {
          val api: FinspaceAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Finspace = this
          def deleteEnvironment(request: DeleteEnvironmentRequest): IO[
            AwsError,
            zio.aws.finspace.model.DeleteEnvironmentResponse.ReadOnly
          ] = proxy(DeleteEnvironment, request)
          def createEnvironment(
              request: CreateEnvironmentRequest
          ): IO[AwsError, ReadOnly] = proxy(CreateEnvironment, request)
          def getEnvironment(request: GetEnvironmentRequest): IO[
            AwsError,
            zio.aws.finspace.model.GetEnvironmentResponse.ReadOnly
          ] = proxy(GetEnvironment, request)
          def listEnvironments(request: ListEnvironmentsRequest): IO[
            AwsError,
            zio.aws.finspace.model.ListEnvironmentsResponse.ReadOnly
          ] = proxy(ListEnvironments, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.finspace.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.finspace.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.finspace.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def updateEnvironment(request: UpdateEnvironmentRequest): IO[
            AwsError,
            zio.aws.finspace.model.UpdateEnvironmentResponse.ReadOnly
          ] = proxy(UpdateEnvironment, request)
        }
      }
    }
    .toLayer
}
