package zio.aws.finspace.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetEnvironmentResponse(
    environment: Option[zio.aws.finspace.model.Environment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.GetEnvironmentResponse = {
    import GetEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.GetEnvironmentResponse
      .builder()
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.GetEnvironmentResponse.ReadOnly =
    zio.aws.finspace.model.GetEnvironmentResponse.wrap(buildAwsValue())
}
object GetEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.GetEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.GetEnvironmentResponse =
      zio.aws.finspace.model
        .GetEnvironmentResponse(environment.map(value => value.asEditable))
    def environment: Option[zio.aws.finspace.model.Environment.ReadOnly]
    def getEnvironment
        : ZIO[Any, AwsError, zio.aws.finspace.model.Environment.ReadOnly] =
      AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.GetEnvironmentResponse
  ) extends zio.aws.finspace.model.GetEnvironmentResponse.ReadOnly {
    override val environment
        : Option[zio.aws.finspace.model.Environment.ReadOnly] = scala
      .Option(impl.environment())
      .map(value => zio.aws.finspace.model.Environment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.GetEnvironmentResponse
  ): zio.aws.finspace.model.GetEnvironmentResponse.ReadOnly = new Wrapper(impl)
}
