package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  Urn,
  SamlMetadataDocument,
  Url,
  FederationProviderName,
  FederationAttributeKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FederationParameters(
    samlMetadataDocument: Option[SamlMetadataDocument] = None,
    samlMetadataURL: Option[Url] = None,
    applicationCallBackURL: Option[Url] = None,
    federationURN: Option[Urn] = None,
    federationProviderName: Option[FederationProviderName] = None,
    attributeMap: Option[Map[FederationAttributeKey, Url]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.FederationParameters = {
    import FederationParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.FederationParameters
      .builder()
      .optionallyWith(
        samlMetadataDocument.map(value =>
          SamlMetadataDocument.unwrap(value): java.lang.String
        )
      )(_.samlMetadataDocument)
      .optionallyWith(
        samlMetadataURL.map(value => Url.unwrap(value): java.lang.String)
      )(_.samlMetadataURL)
      .optionallyWith(
        applicationCallBackURL.map(value => Url.unwrap(value): java.lang.String)
      )(_.applicationCallBackURL)
      .optionallyWith(
        federationURN.map(value => Urn.unwrap(value): java.lang.String)
      )(_.federationURN)
      .optionallyWith(
        federationProviderName.map(value =>
          FederationProviderName.unwrap(value): java.lang.String
        )
      )(_.federationProviderName)
      .optionallyWith(
        attributeMap.map(value =>
          value
            .map({ case (key, value) =>
              (FederationAttributeKey.unwrap(key): java.lang.String) -> (Url
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributeMap)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.FederationParameters.ReadOnly =
    zio.aws.finspace.model.FederationParameters.wrap(buildAwsValue())
}
object FederationParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.FederationParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.FederationParameters =
      zio.aws.finspace.model.FederationParameters(
        samlMetadataDocument.map(value => value),
        samlMetadataURL.map(value => value),
        applicationCallBackURL.map(value => value),
        federationURN.map(value => value),
        federationProviderName.map(value => value),
        attributeMap.map(value => value)
      )
    def samlMetadataDocument: Option[SamlMetadataDocument]
    def samlMetadataURL: Option[Url]
    def applicationCallBackURL: Option[Url]
    def federationURN: Option[Urn]
    def federationProviderName: Option[FederationProviderName]
    def attributeMap: Option[Map[FederationAttributeKey, Url]]
    def getSamlMetadataDocument: ZIO[Any, AwsError, SamlMetadataDocument] =
      AwsError.unwrapOptionField("samlMetadataDocument", samlMetadataDocument)
    def getSamlMetadataURL: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("samlMetadataURL", samlMetadataURL)
    def getApplicationCallBackURL: ZIO[Any, AwsError, Url] = AwsError
      .unwrapOptionField("applicationCallBackURL", applicationCallBackURL)
    def getFederationURN: ZIO[Any, AwsError, Urn] =
      AwsError.unwrapOptionField("federationURN", federationURN)
    def getFederationProviderName: ZIO[Any, AwsError, FederationProviderName] =
      AwsError.unwrapOptionField(
        "federationProviderName",
        federationProviderName
      )
    def getAttributeMap: ZIO[Any, AwsError, Map[FederationAttributeKey, Url]] =
      AwsError.unwrapOptionField("attributeMap", attributeMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.FederationParameters
  ) extends zio.aws.finspace.model.FederationParameters.ReadOnly {
    override val samlMetadataDocument: Option[SamlMetadataDocument] = scala
      .Option(impl.samlMetadataDocument())
      .map(value =>
        zio.aws.finspace.model.primitives.SamlMetadataDocument(value)
      )
    override val samlMetadataURL: Option[Url] = scala
      .Option(impl.samlMetadataURL())
      .map(value => zio.aws.finspace.model.primitives.Url(value))
    override val applicationCallBackURL: Option[Url] = scala
      .Option(impl.applicationCallBackURL())
      .map(value => zio.aws.finspace.model.primitives.Url(value))
    override val federationURN: Option[Urn] = scala
      .Option(impl.federationURN())
      .map(value => zio.aws.finspace.model.primitives.Urn(value))
    override val federationProviderName: Option[FederationProviderName] = scala
      .Option(impl.federationProviderName())
      .map(value =>
        zio.aws.finspace.model.primitives.FederationProviderName(value)
      )
    override val attributeMap: Option[Map[FederationAttributeKey, Url]] = scala
      .Option(impl.attributeMap())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.finspace.model.primitives.FederationAttributeKey(
              key
            ) -> zio.aws.finspace.model.primitives.Url(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.FederationParameters
  ): zio.aws.finspace.model.FederationParameters.ReadOnly = new Wrapper(impl)
}
