package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ProjectDataDeliveryConfig(
    cloudWatchLogs: Optional[
      zio.aws.evidently.model.CloudWatchLogsDestinationConfig
    ] = Optional.Absent,
    s3Destination: Optional[zio.aws.evidently.model.S3DestinationConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ProjectDataDeliveryConfig = {
    import ProjectDataDeliveryConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ProjectDataDeliveryConfig
      .builder()
      .optionallyWith(cloudWatchLogs.map(value => value.buildAwsValue()))(
        _.cloudWatchLogs
      )
      .optionallyWith(s3Destination.map(value => value.buildAwsValue()))(
        _.s3Destination
      )
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ProjectDataDeliveryConfig.ReadOnly =
    zio.aws.evidently.model.ProjectDataDeliveryConfig.wrap(buildAwsValue())
}
object ProjectDataDeliveryConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ProjectDataDeliveryConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ProjectDataDeliveryConfig =
      zio.aws.evidently.model.ProjectDataDeliveryConfig(
        cloudWatchLogs.map(value => value.asEditable),
        s3Destination.map(value => value.asEditable)
      )
    def cloudWatchLogs: Optional[
      zio.aws.evidently.model.CloudWatchLogsDestinationConfig.ReadOnly
    ]
    def s3Destination
        : Optional[zio.aws.evidently.model.S3DestinationConfig.ReadOnly]
    def getCloudWatchLogs: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.CloudWatchLogsDestinationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("cloudWatchLogs", cloudWatchLogs)
    def getS3Destination: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.S3DestinationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("s3Destination", s3Destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ProjectDataDeliveryConfig
  ) extends zio.aws.evidently.model.ProjectDataDeliveryConfig.ReadOnly {
    override val cloudWatchLogs: Optional[
      zio.aws.evidently.model.CloudWatchLogsDestinationConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLogs())
      .map(value =>
        zio.aws.evidently.model.CloudWatchLogsDestinationConfig.wrap(value)
      )
    override val s3Destination
        : Optional[zio.aws.evidently.model.S3DestinationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Destination())
        .map(value => zio.aws.evidently.model.S3DestinationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ProjectDataDeliveryConfig
  ): zio.aws.evidently.model.ProjectDataDeliveryConfig.ReadOnly = new Wrapper(
    impl
  )
}
