package zio.aws.evidently.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.evidently.model.primitives.{ProjectRef, NextToken, MaxLaunches}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListLaunchesRequest(
    maxResults: Optional[MaxLaunches] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    project: ProjectRef,
    status: Optional[zio.aws.evidently.model.LaunchStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ListLaunchesRequest = {
    import ListLaunchesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ListLaunchesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxLaunches.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ListLaunchesRequest.ReadOnly =
    zio.aws.evidently.model.ListLaunchesRequest.wrap(buildAwsValue())
}
object ListLaunchesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ListLaunchesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ListLaunchesRequest =
      zio.aws.evidently.model.ListLaunchesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        project,
        status.map(value => value)
      )
    def maxResults: Optional[MaxLaunches]
    def nextToken: Optional[NextToken]
    def project: ProjectRef
    def status: Optional[zio.aws.evidently.model.LaunchStatus]
    def getMaxResults: ZIO[Any, AwsError, MaxLaunches] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
    def getStatus: ZIO[Any, AwsError, zio.aws.evidently.model.LaunchStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ListLaunchesRequest
  ) extends zio.aws.evidently.model.ListLaunchesRequest.ReadOnly {
    override val maxResults: Optional[MaxLaunches] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.evidently.model.primitives.MaxLaunches(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.evidently.model.primitives.NextToken(value))
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
    override val status: Optional[zio.aws.evidently.model.LaunchStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.evidently.model.LaunchStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ListLaunchesRequest
  ): zio.aws.evidently.model.ListLaunchesRequest.ReadOnly = new Wrapper(impl)
}
