package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateProjectDataDeliveryResponse(
    project: zio.aws.evidently.model.Project
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.UpdateProjectDataDeliveryResponse = {
    import UpdateProjectDataDeliveryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.UpdateProjectDataDeliveryResponse
      .builder()
      .project(project.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.evidently.model.UpdateProjectDataDeliveryResponse.ReadOnly =
    zio.aws.evidently.model.UpdateProjectDataDeliveryResponse
      .wrap(buildAwsValue())
}
object UpdateProjectDataDeliveryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.UpdateProjectDataDeliveryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.UpdateProjectDataDeliveryResponse =
      zio.aws.evidently.model
        .UpdateProjectDataDeliveryResponse(project.asEditable)
    def project: zio.aws.evidently.model.Project.ReadOnly
    def getProject
        : ZIO[Any, Nothing, zio.aws.evidently.model.Project.ReadOnly] =
      ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.UpdateProjectDataDeliveryResponse
  ) extends zio.aws.evidently.model.UpdateProjectDataDeliveryResponse.ReadOnly {
    override val project: zio.aws.evidently.model.Project.ReadOnly =
      zio.aws.evidently.model.Project.wrap(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.UpdateProjectDataDeliveryResponse
  ): zio.aws.evidently.model.UpdateProjectDataDeliveryResponse.ReadOnly =
    new Wrapper(impl)
}
