package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{JsonValue, SegmentPattern}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TestSegmentPatternRequest(
    pattern: SegmentPattern,
    payload: JsonValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.TestSegmentPatternRequest = {
    import TestSegmentPatternRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.TestSegmentPatternRequest
      .builder()
      .pattern(SegmentPattern.unwrap(pattern): java.lang.String)
      .payload(JsonValue.unwrap(payload): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.TestSegmentPatternRequest.ReadOnly =
    zio.aws.evidently.model.TestSegmentPatternRequest.wrap(buildAwsValue())
}
object TestSegmentPatternRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.TestSegmentPatternRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.TestSegmentPatternRequest =
      zio.aws.evidently.model.TestSegmentPatternRequest(pattern, payload)
    def pattern: SegmentPattern
    def payload: JsonValue
    def getPattern: ZIO[Any, Nothing, SegmentPattern] = ZIO.succeed(pattern)
    def getPayload: ZIO[Any, Nothing, JsonValue] = ZIO.succeed(payload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.TestSegmentPatternRequest
  ) extends zio.aws.evidently.model.TestSegmentPatternRequest.ReadOnly {
    override val pattern: SegmentPattern =
      zio.aws.evidently.model.primitives.SegmentPattern(impl.pattern())
    override val payload: JsonValue =
      zio.aws.evidently.model.primitives.JsonValue(impl.payload())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.TestSegmentPatternRequest
  ): zio.aws.evidently.model.TestSegmentPatternRequest.ReadOnly = new Wrapper(
    impl
  )
}
