package zio.aws.evidently.model
import scala.jdk.CollectionConverters.*
sealed trait SegmentReferenceResourceType {
  def unwrap: software.amazon.awssdk.services.evidently.model.SegmentReferenceResourceType
}
object SegmentReferenceResourceType {
  def wrap(
      value: software.amazon.awssdk.services.evidently.model.SegmentReferenceResourceType
  ): zio.aws.evidently.model.SegmentReferenceResourceType = value match {
    case software.amazon.awssdk.services.evidently.model.SegmentReferenceResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.evidently.model.SegmentReferenceResourceType.EXPERIMENT =>
      val r = EXPERIMENT
      r
    case software.amazon.awssdk.services.evidently.model.SegmentReferenceResourceType.LAUNCH =>
      val r = LAUNCH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.evidently.model.SegmentReferenceResourceType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.SegmentReferenceResourceType =
      software.amazon.awssdk.services.evidently.model.SegmentReferenceResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object EXPERIMENT
      extends zio.aws.evidently.model.SegmentReferenceResourceType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.SegmentReferenceResourceType =
      software.amazon.awssdk.services.evidently.model.SegmentReferenceResourceType.EXPERIMENT
  }
  case object LAUNCH
      extends zio.aws.evidently.model.SegmentReferenceResourceType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.SegmentReferenceResourceType =
      software.amazon.awssdk.services.evidently.model.SegmentReferenceResourceType.LAUNCH
  }
}
