package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.AppConfigResourceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ProjectAppConfigResourceConfig(
    applicationId: Optional[AppConfigResourceId] = Optional.Absent,
    environmentId: Optional[AppConfigResourceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ProjectAppConfigResourceConfig = {
    import ProjectAppConfigResourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ProjectAppConfigResourceConfig
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          AppConfigResourceId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        environmentId.map(value =>
          AppConfigResourceId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .build()
  }
  def asReadOnly
      : zio.aws.evidently.model.ProjectAppConfigResourceConfig.ReadOnly =
    zio.aws.evidently.model.ProjectAppConfigResourceConfig.wrap(buildAwsValue())
}
object ProjectAppConfigResourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ProjectAppConfigResourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ProjectAppConfigResourceConfig =
      zio.aws.evidently.model.ProjectAppConfigResourceConfig(
        applicationId.map(value => value),
        environmentId.map(value => value)
      )
    def applicationId: Optional[AppConfigResourceId]
    def environmentId: Optional[AppConfigResourceId]
    def getApplicationId: ZIO[Any, AwsError, AppConfigResourceId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getEnvironmentId: ZIO[Any, AwsError, AppConfigResourceId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ProjectAppConfigResourceConfig
  ) extends zio.aws.evidently.model.ProjectAppConfigResourceConfig.ReadOnly {
    override val applicationId: Optional[AppConfigResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationId())
        .map(value =>
          zio.aws.evidently.model.primitives.AppConfigResourceId(value)
        )
    override val environmentId: Optional[AppConfigResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentId())
        .map(value =>
          zio.aws.evidently.model.primitives.AppConfigResourceId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ProjectAppConfigResourceConfig
  ): zio.aws.evidently.model.ProjectAppConfigResourceConfig.ReadOnly =
    new Wrapper(impl)
}
