package zio.aws.evidently.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.evidently.model.primitives.{NextToken, MaxSegments}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSegmentsRequest(
    maxResults: Optional[MaxSegments] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ListSegmentsRequest = {
    import ListSegmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ListSegmentsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxSegments.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ListSegmentsRequest.ReadOnly =
    zio.aws.evidently.model.ListSegmentsRequest.wrap(buildAwsValue())
}
object ListSegmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ListSegmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ListSegmentsRequest =
      zio.aws.evidently.model.ListSegmentsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxSegments]
    def nextToken: Optional[NextToken]
    def getMaxResults: ZIO[Any, AwsError, MaxSegments] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ListSegmentsRequest
  ) extends zio.aws.evidently.model.ListSegmentsRequest.ReadOnly {
    override val maxResults: Optional[MaxSegments] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.evidently.model.primitives.MaxSegments(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.evidently.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ListSegmentsRequest
  ): zio.aws.evidently.model.ListSegmentsRequest.ReadOnly = new Wrapper(impl)
}
