package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSegmentResponse(segment: zio.aws.evidently.model.Segment) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.GetSegmentResponse = {
    import GetSegmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.GetSegmentResponse
      .builder()
      .segment(segment.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.GetSegmentResponse.ReadOnly =
    zio.aws.evidently.model.GetSegmentResponse.wrap(buildAwsValue())
}
object GetSegmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.GetSegmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.GetSegmentResponse =
      zio.aws.evidently.model.GetSegmentResponse(segment.asEditable)
    def segment: zio.aws.evidently.model.Segment.ReadOnly
    def getSegment
        : ZIO[Any, Nothing, zio.aws.evidently.model.Segment.ReadOnly] =
      ZIO.succeed(segment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.GetSegmentResponse
  ) extends zio.aws.evidently.model.GetSegmentResponse.ReadOnly {
    override val segment: zio.aws.evidently.model.Segment.ReadOnly =
      zio.aws.evidently.model.Segment.wrap(impl.segment())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.GetSegmentResponse
  ): zio.aws.evidently.model.GetSegmentResponse.ReadOnly = new Wrapper(impl)
}
