package zio.aws.evidently
import zio.aws.evidently.model.ListFeaturesResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.evidently.EvidentlyAsyncClient
import zio.aws.evidently.model.{
  EvaluateFeatureRequest,
  GetSegmentRequest,
  ListSegmentReferencesRequest,
  GetExperimentResultsRequest,
  GetProjectRequest,
  CreateProjectRequest,
  DeleteFeatureRequest,
  StopLaunchRequest,
  StartExperimentRequest,
  StopExperimentRequest,
  ListLaunchesRequest,
  StartLaunchRequest,
  CreateFeatureRequest,
  UpdateExperimentRequest,
  ListTagsForResourceRequest,
  CreateLaunchRequest,
  DeleteSegmentRequest,
  GetExperimentRequest,
  UpdateProjectRequest,
  DeleteProjectRequest,
  PutProjectEventsRequest,
  GetLaunchRequest,
  TestSegmentPatternRequest,
  CreateExperimentRequest,
  ListProjectsRequest,
  UntagResourceRequest,
  CreateSegmentRequest,
  UpdateLaunchRequest,
  DeleteExperimentRequest,
  BatchEvaluateFeatureRequest,
  DeleteLaunchRequest,
  GetFeatureRequest,
  ListExperimentsRequest,
  ListFeaturesRequest,
  ListSegmentsRequest,
  UpdateProjectDataDeliveryRequest,
  UpdateFeatureRequest,
  TagResourceRequest
}
import zio.stream.ZStream
object EvidentlyMock extends Mock[Evidently] {
  object DeleteSegment
      extends Effect[
        DeleteSegmentRequest,
        AwsError,
        zio.aws.evidently.model.DeleteSegmentResponse.ReadOnly
      ]
  object DeleteLaunch
      extends Effect[
        DeleteLaunchRequest,
        AwsError,
        zio.aws.evidently.model.DeleteLaunchResponse.ReadOnly
      ]
  object GetProject
      extends Effect[
        GetProjectRequest,
        AwsError,
        zio.aws.evidently.model.GetProjectResponse.ReadOnly
      ]
  object PutProjectEvents
      extends Effect[
        PutProjectEventsRequest,
        AwsError,
        zio.aws.evidently.model.PutProjectEventsResponse.ReadOnly
      ]
  object GetLaunch
      extends Effect[
        GetLaunchRequest,
        AwsError,
        zio.aws.evidently.model.GetLaunchResponse.ReadOnly
      ]
  object BatchEvaluateFeature
      extends Effect[
        BatchEvaluateFeatureRequest,
        AwsError,
        zio.aws.evidently.model.BatchEvaluateFeatureResponse.ReadOnly
      ]
  object CreateLaunch
      extends Effect[
        CreateLaunchRequest,
        AwsError,
        zio.aws.evidently.model.CreateLaunchResponse.ReadOnly
      ]
  object GetExperimentResults
      extends Effect[
        GetExperimentResultsRequest,
        AwsError,
        zio.aws.evidently.model.GetExperimentResultsResponse.ReadOnly
      ]
  object StopLaunch
      extends Effect[
        StopLaunchRequest,
        AwsError,
        zio.aws.evidently.model.StopLaunchResponse.ReadOnly
      ]
  object UpdateProject
      extends Effect[
        UpdateProjectRequest,
        AwsError,
        zio.aws.evidently.model.UpdateProjectResponse.ReadOnly
      ]
  object CreateFeature
      extends Effect[
        CreateFeatureRequest,
        AwsError,
        zio.aws.evidently.model.CreateFeatureResponse.ReadOnly
      ]
  object DeleteFeature
      extends Effect[
        DeleteFeatureRequest,
        AwsError,
        zio.aws.evidently.model.DeleteFeatureResponse.ReadOnly
      ]
  object CreateExperiment
      extends Effect[
        CreateExperimentRequest,
        AwsError,
        zio.aws.evidently.model.CreateExperimentResponse.ReadOnly
      ]
  object ListProjects
      extends Stream[
        ListProjectsRequest,
        AwsError,
        zio.aws.evidently.model.ProjectSummary.ReadOnly
      ]
  object ListProjectsPaginated
      extends Effect[
        ListProjectsRequest,
        AwsError,
        zio.aws.evidently.model.ListProjectsResponse.ReadOnly
      ]
  object UpdateLaunch
      extends Effect[
        UpdateLaunchRequest,
        AwsError,
        zio.aws.evidently.model.UpdateLaunchResponse.ReadOnly
      ]
  object StartExperiment
      extends Effect[
        StartExperimentRequest,
        AwsError,
        zio.aws.evidently.model.StartExperimentResponse.ReadOnly
      ]
  object DeleteExperiment
      extends Effect[
        DeleteExperimentRequest,
        AwsError,
        zio.aws.evidently.model.DeleteExperimentResponse.ReadOnly
      ]
  object GetFeature
      extends Effect[
        GetFeatureRequest,
        AwsError,
        zio.aws.evidently.model.GetFeatureResponse.ReadOnly
      ]
  object UpdateProjectDataDelivery
      extends Effect[
        UpdateProjectDataDeliveryRequest,
        AwsError,
        zio.aws.evidently.model.UpdateProjectDataDeliveryResponse.ReadOnly
      ]
  object GetSegment
      extends Effect[
        GetSegmentRequest,
        AwsError,
        zio.aws.evidently.model.GetSegmentResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.evidently.model.UntagResourceResponse.ReadOnly
      ]
  object CreateProject
      extends Effect[
        CreateProjectRequest,
        AwsError,
        zio.aws.evidently.model.CreateProjectResponse.ReadOnly
      ]
  object StartLaunch
      extends Effect[
        StartLaunchRequest,
        AwsError,
        zio.aws.evidently.model.StartLaunchResponse.ReadOnly
      ]
  object ListFeatures
      extends Stream[
        ListFeaturesRequest,
        AwsError,
        zio.aws.evidently.model.FeatureSummary.ReadOnly
      ]
  object ListFeaturesPaginated
      extends Effect[ListFeaturesRequest, AwsError, ReadOnly]
  object CreateSegment
      extends Effect[
        CreateSegmentRequest,
        AwsError,
        zio.aws.evidently.model.CreateSegmentResponse.ReadOnly
      ]
  object ListSegments
      extends Stream[
        ListSegmentsRequest,
        AwsError,
        zio.aws.evidently.model.Segment.ReadOnly
      ]
  object ListSegmentsPaginated
      extends Effect[
        ListSegmentsRequest,
        AwsError,
        zio.aws.evidently.model.ListSegmentsResponse.ReadOnly
      ]
  object EvaluateFeature
      extends Effect[
        EvaluateFeatureRequest,
        AwsError,
        zio.aws.evidently.model.EvaluateFeatureResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.evidently.model.ListTagsForResourceResponse.ReadOnly
      ]
  object UpdateExperiment
      extends Effect[
        UpdateExperimentRequest,
        AwsError,
        zio.aws.evidently.model.UpdateExperimentResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.evidently.model.TagResourceResponse.ReadOnly
      ]
  object ListExperiments
      extends Stream[
        ListExperimentsRequest,
        AwsError,
        zio.aws.evidently.model.Experiment.ReadOnly
      ]
  object ListExperimentsPaginated
      extends Effect[
        ListExperimentsRequest,
        AwsError,
        zio.aws.evidently.model.ListExperimentsResponse.ReadOnly
      ]
  object StopExperiment
      extends Effect[
        StopExperimentRequest,
        AwsError,
        zio.aws.evidently.model.StopExperimentResponse.ReadOnly
      ]
  object DeleteProject
      extends Effect[
        DeleteProjectRequest,
        AwsError,
        zio.aws.evidently.model.DeleteProjectResponse.ReadOnly
      ]
  object TestSegmentPattern
      extends Effect[
        TestSegmentPatternRequest,
        AwsError,
        zio.aws.evidently.model.TestSegmentPatternResponse.ReadOnly
      ]
  object UpdateFeature
      extends Effect[
        UpdateFeatureRequest,
        AwsError,
        zio.aws.evidently.model.UpdateFeatureResponse.ReadOnly
      ]
  object GetExperiment
      extends Effect[
        GetExperimentRequest,
        AwsError,
        zio.aws.evidently.model.GetExperimentResponse.ReadOnly
      ]
  object ListLaunches
      extends Stream[
        ListLaunchesRequest,
        AwsError,
        zio.aws.evidently.model.Launch.ReadOnly
      ]
  object ListLaunchesPaginated
      extends Effect[
        ListLaunchesRequest,
        AwsError,
        zio.aws.evidently.model.ListLaunchesResponse.ReadOnly
      ]
  object ListSegmentReferences
      extends Stream[
        ListSegmentReferencesRequest,
        AwsError,
        zio.aws.evidently.model.RefResource.ReadOnly
      ]
  object ListSegmentReferencesPaginated
      extends Effect[
        ListSegmentReferencesRequest,
        AwsError,
        zio.aws.evidently.model.ListSegmentReferencesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Evidently] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Evidently] { rts =>
        zio.ZIO.succeed {
          new Evidently {
            val api: EvidentlyAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Evidently = this
            def deleteSegment(request: DeleteSegmentRequest): IO[
              AwsError,
              zio.aws.evidently.model.DeleteSegmentResponse.ReadOnly
            ] = proxy(DeleteSegment, request)
            def deleteLaunch(request: DeleteLaunchRequest): IO[
              AwsError,
              zio.aws.evidently.model.DeleteLaunchResponse.ReadOnly
            ] = proxy(DeleteLaunch, request)
            def getProject(request: GetProjectRequest): IO[
              AwsError,
              zio.aws.evidently.model.GetProjectResponse.ReadOnly
            ] = proxy(GetProject, request)
            def putProjectEvents(request: PutProjectEventsRequest): IO[
              AwsError,
              zio.aws.evidently.model.PutProjectEventsResponse.ReadOnly
            ] = proxy(PutProjectEvents, request)
            def getLaunch(request: GetLaunchRequest): IO[
              AwsError,
              zio.aws.evidently.model.GetLaunchResponse.ReadOnly
            ] = proxy(GetLaunch, request)
            def batchEvaluateFeature(request: BatchEvaluateFeatureRequest): IO[
              AwsError,
              zio.aws.evidently.model.BatchEvaluateFeatureResponse.ReadOnly
            ] = proxy(BatchEvaluateFeature, request)
            def createLaunch(request: CreateLaunchRequest): IO[
              AwsError,
              zio.aws.evidently.model.CreateLaunchResponse.ReadOnly
            ] = proxy(CreateLaunch, request)
            def getExperimentResults(request: GetExperimentResultsRequest): IO[
              AwsError,
              zio.aws.evidently.model.GetExperimentResultsResponse.ReadOnly
            ] = proxy(GetExperimentResults, request)
            def stopLaunch(request: StopLaunchRequest): IO[
              AwsError,
              zio.aws.evidently.model.StopLaunchResponse.ReadOnly
            ] = proxy(StopLaunch, request)
            def updateProject(request: UpdateProjectRequest): IO[
              AwsError,
              zio.aws.evidently.model.UpdateProjectResponse.ReadOnly
            ] = proxy(UpdateProject, request)
            def createFeature(request: CreateFeatureRequest): IO[
              AwsError,
              zio.aws.evidently.model.CreateFeatureResponse.ReadOnly
            ] = proxy(CreateFeature, request)
            def deleteFeature(request: DeleteFeatureRequest): IO[
              AwsError,
              zio.aws.evidently.model.DeleteFeatureResponse.ReadOnly
            ] = proxy(DeleteFeature, request)
            def createExperiment(request: CreateExperimentRequest): IO[
              AwsError,
              zio.aws.evidently.model.CreateExperimentResponse.ReadOnly
            ] = proxy(CreateExperiment, request)
            def listProjects(request: ListProjectsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.evidently.model.ProjectSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListProjects, request)
                }
                .getOrThrowFiberFailure()
            }
            def listProjectsPaginated(request: ListProjectsRequest): IO[
              AwsError,
              zio.aws.evidently.model.ListProjectsResponse.ReadOnly
            ] = proxy(ListProjectsPaginated, request)
            def updateLaunch(request: UpdateLaunchRequest): IO[
              AwsError,
              zio.aws.evidently.model.UpdateLaunchResponse.ReadOnly
            ] = proxy(UpdateLaunch, request)
            def startExperiment(request: StartExperimentRequest): IO[
              AwsError,
              zio.aws.evidently.model.StartExperimentResponse.ReadOnly
            ] = proxy(StartExperiment, request)
            def deleteExperiment(request: DeleteExperimentRequest): IO[
              AwsError,
              zio.aws.evidently.model.DeleteExperimentResponse.ReadOnly
            ] = proxy(DeleteExperiment, request)
            def getFeature(request: GetFeatureRequest): IO[
              AwsError,
              zio.aws.evidently.model.GetFeatureResponse.ReadOnly
            ] = proxy(GetFeature, request)
            def updateProjectDataDelivery(
                request: UpdateProjectDataDeliveryRequest
            ): IO[
              AwsError,
              zio.aws.evidently.model.UpdateProjectDataDeliveryResponse.ReadOnly
            ] = proxy(UpdateProjectDataDelivery, request)
            def getSegment(request: GetSegmentRequest): IO[
              AwsError,
              zio.aws.evidently.model.GetSegmentResponse.ReadOnly
            ] = proxy(GetSegment, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.evidently.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createProject(request: CreateProjectRequest): IO[
              AwsError,
              zio.aws.evidently.model.CreateProjectResponse.ReadOnly
            ] = proxy(CreateProject, request)
            def startLaunch(request: StartLaunchRequest): IO[
              AwsError,
              zio.aws.evidently.model.StartLaunchResponse.ReadOnly
            ] = proxy(StartLaunch, request)
            def listFeatures(request: ListFeaturesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.evidently.model.FeatureSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFeatures, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFeaturesPaginated(
                request: ListFeaturesRequest
            ): IO[AwsError, ReadOnly] = proxy(ListFeaturesPaginated, request)
            def createSegment(request: CreateSegmentRequest): IO[
              AwsError,
              zio.aws.evidently.model.CreateSegmentResponse.ReadOnly
            ] = proxy(CreateSegment, request)
            def listSegments(request: ListSegmentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.evidently.model.Segment.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSegments, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSegmentsPaginated(request: ListSegmentsRequest): IO[
              AwsError,
              zio.aws.evidently.model.ListSegmentsResponse.ReadOnly
            ] = proxy(ListSegmentsPaginated, request)
            def evaluateFeature(request: EvaluateFeatureRequest): IO[
              AwsError,
              zio.aws.evidently.model.EvaluateFeatureResponse.ReadOnly
            ] = proxy(EvaluateFeature, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.evidently.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def updateExperiment(request: UpdateExperimentRequest): IO[
              AwsError,
              zio.aws.evidently.model.UpdateExperimentResponse.ReadOnly
            ] = proxy(UpdateExperiment, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.evidently.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listExperiments(request: ListExperimentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.evidently.model.Experiment.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListExperiments, request)
                }
                .getOrThrowFiberFailure()
            }
            def listExperimentsPaginated(request: ListExperimentsRequest): IO[
              AwsError,
              zio.aws.evidently.model.ListExperimentsResponse.ReadOnly
            ] = proxy(ListExperimentsPaginated, request)
            def stopExperiment(request: StopExperimentRequest): IO[
              AwsError,
              zio.aws.evidently.model.StopExperimentResponse.ReadOnly
            ] = proxy(StopExperiment, request)
            def deleteProject(request: DeleteProjectRequest): IO[
              AwsError,
              zio.aws.evidently.model.DeleteProjectResponse.ReadOnly
            ] = proxy(DeleteProject, request)
            def testSegmentPattern(request: TestSegmentPatternRequest): IO[
              AwsError,
              zio.aws.evidently.model.TestSegmentPatternResponse.ReadOnly
            ] = proxy(TestSegmentPattern, request)
            def updateFeature(request: UpdateFeatureRequest): IO[
              AwsError,
              zio.aws.evidently.model.UpdateFeatureResponse.ReadOnly
            ] = proxy(UpdateFeature, request)
            def getExperiment(request: GetExperimentRequest): IO[
              AwsError,
              zio.aws.evidently.model.GetExperimentResponse.ReadOnly
            ] = proxy(GetExperiment, request)
            def listLaunches(
                request: ListLaunchesRequest
            ): ZStream[Any, AwsError, zio.aws.evidently.model.Launch.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListLaunches, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listLaunchesPaginated(request: ListLaunchesRequest): IO[
              AwsError,
              zio.aws.evidently.model.ListLaunchesResponse.ReadOnly
            ] = proxy(ListLaunchesPaginated, request)
            def listSegmentReferences(
                request: ListSegmentReferencesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.evidently.model.RefResource.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSegmentReferences, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSegmentReferencesPaginated(
                request: ListSegmentReferencesRequest
            ): IO[
              AwsError,
              zio.aws.evidently.model.ListSegmentReferencesResponse.ReadOnly
            ] = proxy(ListSegmentReferencesPaginated, request)
          }
        }
      }
    }
  }
}
