package zio.aws.evidently.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.evidently.model.primitives.{
  SegmentName,
  Timestamp,
  TagValue,
  SegmentPattern,
  Description,
  TagKey,
  SegmentArn
}
import scala.jdk.CollectionConverters.*
final case class Segment(
    arn: SegmentArn,
    createdTime: Timestamp,
    description: Optional[Description] = Optional.Absent,
    experimentCount: Optional[Long] = Optional.Absent,
    lastUpdatedTime: Timestamp,
    launchCount: Optional[Long] = Optional.Absent,
    name: SegmentName,
    pattern: SegmentPattern,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.Segment = {
    import Segment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.Segment
      .builder()
      .arn(SegmentArn.unwrap(arn): java.lang.String)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(experimentCount.map(value => value: java.lang.Long))(
        _.experimentCount
      )
      .lastUpdatedTime(Timestamp.unwrap(lastUpdatedTime): Instant)
      .optionallyWith(launchCount.map(value => value: java.lang.Long))(
        _.launchCount
      )
      .name(SegmentName.unwrap(name): java.lang.String)
      .pattern(SegmentPattern.unwrap(pattern): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.Segment.ReadOnly =
    zio.aws.evidently.model.Segment.wrap(buildAwsValue())
}
object Segment {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.evidently.model.Segment] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.Segment =
      zio.aws.evidently.model.Segment(
        arn,
        createdTime,
        description.map(value => value),
        experimentCount.map(value => value),
        lastUpdatedTime,
        launchCount.map(value => value),
        name,
        pattern,
        tags.map(value => value)
      )
    def arn: SegmentArn
    def createdTime: Timestamp
    def description: Optional[Description]
    def experimentCount: Optional[Long]
    def lastUpdatedTime: Timestamp
    def launchCount: Optional[Long]
    def name: SegmentName
    def pattern: SegmentPattern
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, Nothing, SegmentArn] = ZIO.succeed(arn)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getExperimentCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("experimentCount", experimentCount)
    def getLastUpdatedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedTime)
    def getLaunchCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("launchCount", launchCount)
    def getName: ZIO[Any, Nothing, SegmentName] = ZIO.succeed(name)
    def getPattern: ZIO[Any, Nothing, SegmentPattern] = ZIO.succeed(pattern)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.Segment
  ) extends zio.aws.evidently.model.Segment.ReadOnly {
    override val arn: SegmentArn =
      zio.aws.evidently.model.primitives.SegmentArn(impl.arn())
    override val createdTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.createdTime())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val experimentCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.experimentCount())
      .map(value => value: Long)
    override val lastUpdatedTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.lastUpdatedTime())
    override val launchCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.launchCount())
      .map(value => value: Long)
    override val name: SegmentName =
      zio.aws.evidently.model.primitives.SegmentName(impl.name())
    override val pattern: SegmentPattern =
      zio.aws.evidently.model.primitives.SegmentPattern(impl.pattern())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives
              .TagKey(key) -> zio.aws.evidently.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.Segment
  ): zio.aws.evidently.model.Segment.ReadOnly = new Wrapper(impl)
}
