package zio.aws.evidently.model
import scala.jdk.CollectionConverters.*
sealed trait ProjectStatus {
  def unwrap: software.amazon.awssdk.services.evidently.model.ProjectStatus
}
object ProjectStatus {
  def wrap(
      value: software.amazon.awssdk.services.evidently.model.ProjectStatus
  ): zio.aws.evidently.model.ProjectStatus = value match {
    case software.amazon.awssdk.services.evidently.model.ProjectStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.evidently.model.ProjectStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.evidently.model.ProjectStatus.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.evidently.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ProjectStatus =
      software.amazon.awssdk.services.evidently.model.ProjectStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.evidently.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ProjectStatus =
      software.amazon.awssdk.services.evidently.model.ProjectStatus.AVAILABLE
  }
  case object UPDATING extends zio.aws.evidently.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ProjectStatus =
      software.amazon.awssdk.services.evidently.model.ProjectStatus.UPDATING
  }
}
