package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.AppConfigResourceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ProjectAppConfigResource(
    applicationId: AppConfigResourceId,
    configurationProfileId: AppConfigResourceId,
    environmentId: AppConfigResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ProjectAppConfigResource = {
    import ProjectAppConfigResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ProjectAppConfigResource
      .builder()
      .applicationId(
        AppConfigResourceId.unwrap(applicationId): java.lang.String
      )
      .configurationProfileId(
        AppConfigResourceId.unwrap(configurationProfileId): java.lang.String
      )
      .environmentId(
        AppConfigResourceId.unwrap(environmentId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ProjectAppConfigResource.ReadOnly =
    zio.aws.evidently.model.ProjectAppConfigResource.wrap(buildAwsValue())
}
object ProjectAppConfigResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ProjectAppConfigResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ProjectAppConfigResource =
      zio.aws.evidently.model.ProjectAppConfigResource(
        applicationId,
        configurationProfileId,
        environmentId
      )
    def applicationId: AppConfigResourceId
    def configurationProfileId: AppConfigResourceId
    def environmentId: AppConfigResourceId
    def getApplicationId: ZIO[Any, Nothing, AppConfigResourceId] =
      ZIO.succeed(applicationId)
    def getConfigurationProfileId: ZIO[Any, Nothing, AppConfigResourceId] =
      ZIO.succeed(configurationProfileId)
    def getEnvironmentId: ZIO[Any, Nothing, AppConfigResourceId] =
      ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ProjectAppConfigResource
  ) extends zio.aws.evidently.model.ProjectAppConfigResource.ReadOnly {
    override val applicationId: AppConfigResourceId =
      zio.aws.evidently.model.primitives
        .AppConfigResourceId(impl.applicationId())
    override val configurationProfileId: AppConfigResourceId =
      zio.aws.evidently.model.primitives
        .AppConfigResourceId(impl.configurationProfileId())
    override val environmentId: AppConfigResourceId =
      zio.aws.evidently.model.primitives
        .AppConfigResourceId(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ProjectAppConfigResource
  ): zio.aws.evidently.model.ProjectAppConfigResource.ReadOnly = new Wrapper(
    impl
  )
}
