package zio.aws.evidently.model
import scala.jdk.CollectionConverters.*
sealed trait LaunchType {
  def unwrap: software.amazon.awssdk.services.evidently.model.LaunchType
}
object LaunchType {
  def wrap(
      value: software.amazon.awssdk.services.evidently.model.LaunchType
  ): zio.aws.evidently.model.LaunchType = value match {
    case software.amazon.awssdk.services.evidently.model.LaunchType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.evidently.model.LaunchType.AWS_EVIDENTLY_SPLITS =>
      val r = `aws.evidently.splits`
      r
  }
  case object unknownToSdkVersion extends zio.aws.evidently.model.LaunchType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.LaunchType =
      software.amazon.awssdk.services.evidently.model.LaunchType.UNKNOWN_TO_SDK_VERSION
  }
  case object `aws.evidently.splits`
      extends zio.aws.evidently.model.LaunchType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.LaunchType =
      software.amazon.awssdk.services.evidently.model.LaunchType.AWS_EVIDENTLY_SPLITS
  }
}
