package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{RuleType, RuleName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EvaluationRule(
    name: Optional[RuleName] = Optional.Absent,
    `type`: RuleType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.EvaluationRule = {
    import EvaluationRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.EvaluationRule
      .builder()
      .optionallyWith(
        name.map(value => RuleName.unwrap(value): java.lang.String)
      )(_.name)
      .`type`(RuleType.unwrap(`type`): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.EvaluationRule.ReadOnly =
    zio.aws.evidently.model.EvaluationRule.wrap(buildAwsValue())
}
object EvaluationRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.EvaluationRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.EvaluationRule =
      zio.aws.evidently.model.EvaluationRule(name.map(value => value), `type`)
    def name: Optional[RuleName]
    def `type`: RuleType
    def getName: ZIO[Any, AwsError, RuleName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, Nothing, RuleType] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.EvaluationRule
  ) extends zio.aws.evidently.model.EvaluationRule.ReadOnly {
    override val name: Optional[RuleName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.evidently.model.primitives.RuleName(value))
    override val `type`: RuleType =
      zio.aws.evidently.model.primitives.RuleType(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.EvaluationRule
  ): zio.aws.evidently.model.EvaluationRule.ReadOnly = new Wrapper(impl)
}
